/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.mongo;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.queue.LockedMessageDao;
import cn.mzhong.janytask.queue.Message;
import cn.mzhong.janytask.queue.QueueInfo;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.result.UpdateResult;
import java.util.LinkedList;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDbMessageDao
extends LockedMessageDao {
    MongoCollection collection;

    public MongoDbMessageDao(TaskContext context, QueueInfo queueInfo, MongoCollection collection) {
        super(context, queueInfo);
        this.collection = collection;
    }

    @Override
    protected LinkedList<String> queueIdList() {
        MongoCursor iterator = this.collection.find().projection(new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = new BsonDocument();
                bsonDocument.append("id", null);
                return bsonDocument;
            }
        }).returnKey(true).iterator();
        LinkedList<String> cacheKeys = new LinkedList<String>();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            if (message == null) continue;
            cacheKeys.add(message.getId());
        }
        return cacheKeys;
    }

    @Override
    protected Message get(final String id) {
        MongoCursor iterator = this.collection.find(new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = new BsonDocument();
                bsonDocument.append("id", (BsonValue)new BsonString(id));
                return bsonDocument;
            }
        }).iterator();
        if (iterator.hasNext()) {
            return (Message)iterator.next();
        }
        return null;
    }

    @Override
    protected boolean lock(final String id) {
        UpdateResult updateResult = this.collection.updateOne(new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = new BsonDocument();
                bsonDocument.append("id", (BsonValue)new BsonString(id));
                bsonDocument.append("status", (BsonValue)new BsonString("W"));
                return bsonDocument;
            }
        }, new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = new BsonDocument();
                bsonDocument.append("status", (BsonValue)new BsonString("L"));
                return bsonDocument;
            }
        });
        return updateResult.isModifiedCountAvailable();
    }

    @Override
    protected boolean unLock(final String id) {
        UpdateResult updateResult = this.collection.updateOne(new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = new BsonDocument();
                bsonDocument.append("id", (BsonValue)new BsonString(id));
                bsonDocument.append("status", (BsonValue)new BsonString("L"));
                return bsonDocument;
            }
        }, new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = new BsonDocument();
                bsonDocument.append("status", (BsonValue)new BsonString("W"));
                return bsonDocument;
            }
        });
        return updateResult.isModifiedCountAvailable();
    }

    @Override
    public void push(Message message) {
    }

    @Override
    public void done(Message message) {
    }

    @Override
    public void error(Message message) {
    }

    @Override
    public long length() {
        return this.collection.count();
    }
}

