/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.pipleline;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.executor.TaskExecutor;
import cn.mzhong.janytask.pipleline.PipleLineAnnotationHandler;
import cn.mzhong.janytask.pipleline.Pipleline;
import cn.mzhong.janytask.queue.Message;
import cn.mzhong.janytask.queue.MessageDao;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.util.ValueUtils;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PiplelineTaskExecutor
extends TaskExecutor<Pipleline> {
    Pipleline pipleline;
    Logger Log = LoggerFactory.getLogger(PipleLineAnnotationHandler.class);

    public PiplelineTaskExecutor(TaskContext context, QueueInfo<Pipleline> queueInfo) {
        super(context, queueInfo);
        this.pipleline = queueInfo.getAnnotation();
        this.idleInterval = ValueUtils.uLong(this.pipleline.idleInterval(), this.idleInterval);
        this.sleepInterval = ValueUtils.uLong(this.pipleline.sleepInterval(), this.sleepInterval);
    }

    @Override
    protected void invoke(Message message) {
        Object consumer = this.queueInfo.getConsumer();
        Method method = this.queueInfo.getConsumerMethod();
        MessageDao messageDao = this.queueInfo.getMessageDao();
        try {
            method.invoke(consumer, message.getContent());
            messageDao.done(message);
        }
        catch (Exception e) {
            this.Log.error(e.getLocalizedMessage(), (Throwable)e);
            message.setThrowable(e);
            messageDao.error(message);
        }
    }
}

