/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.producer;

import cn.mzhong.janytask.core.TaskAnnotationHandler;
import cn.mzhong.janytask.core.TaskComponentInitializer;
import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.producer.TaskProducerFactory;
import cn.mzhong.janytask.queue.MessageDao;
import cn.mzhong.janytask.queue.QueueInfo;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskProducerInitializer
implements TaskComponentInitializer {
    static final Logger Log = LoggerFactory.getLogger(TaskProducerInitializer.class);

    protected void processProducer(TaskContext context, Class<?> producerClass) {
        for (Method method : producerClass.getMethods()) {
            for (TaskAnnotationHandler annotationProcessor : context.getAnnotationHandlers()) {
                Object annotation = method.getAnnotation(annotationProcessor.getAnnotationClass());
                if (annotation == null) continue;
                QueueInfo queueInfo = new QueueInfo(annotation, producerClass, method, null, null, null);
                Map<Method, MessageDao> methodMessageDaoMap = context.getMethodMessageDaoMap();
                MessageDao messageDao = context.getQueueProvider().createMessageDao(queueInfo);
                queueInfo.setMessageDao(messageDao);
                methodMessageDaoMap.put(queueInfo.getProducerMethod(), messageDao);
                annotationProcessor.handleProducer(context, queueInfo);
                if (!Log.isDebugEnabled()) continue;
                Log.debug("producer:'" + queueInfo.ID() + "'inited.");
            }
        }
    }

    @Override
    public void init(TaskContext context) {
        for (Class<?> producerClass : context.getProducerClassSet()) {
            Object producer = TaskProducerFactory.newInstance(context, producerClass);
            context.getProducerMap().put(producerClass, producer);
            this.processProducer(context, producerClass);
        }
    }
}

