/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.queue;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.queue.AbstractMessageDao;
import cn.mzhong.janytask.queue.Message;
import cn.mzhong.janytask.queue.QueueInfo;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockedMessageDao
extends AbstractMessageDao {
    private LinkedList<String> cacheKeys = new LinkedList();

    public LockedMessageDao(TaskContext context, QueueInfo queueInfo) {
        super(context, queueInfo);
    }

    @Override
    public final Message poll() {
        if (this.cacheKeys.isEmpty()) {
            this.cacheKeys = this.queueIdList();
        }
        while (!this.cacheKeys.isEmpty() && !this.context.isShutdown()) {
            String key = this.cacheKeys.poll();
            if (!this.lock(key)) continue;
            return this.get(key);
        }
        return null;
    }

    @Override
    public final void back(Message message) {
        this.unLock(message.getId());
    }

    protected abstract LinkedList<String> queueIdList();

    protected abstract Message get(String var1);

    protected abstract boolean lock(String var1);

    protected abstract boolean unLock(String var1);
}

