/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.redis;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.queue.LockedMessageDao;
import cn.mzhong.janytask.queue.Message;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.redis.RedisClient;
import cn.mzhong.janytask.redis.RedisConnectionFactory;
import cn.mzhong.janytask.tool.PRInvoker;
import java.util.Iterator;
import java.util.LinkedList;
import redis.clients.jedis.Jedis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisMessageDao
extends LockedMessageDao {
    protected byte[] waitKey;
    protected byte[] doneKey;
    protected byte[] errorKey;
    protected byte[] lockKey;
    protected RedisClient redisClient;

    private static String key(String rootPath, QueueInfo queueInfo) {
        return rootPath + ":" + queueInfo.ID();
    }

    public RedisMessageDao(TaskContext context, RedisConnectionFactory connectionFactory, QueueInfo queueInfo, String rootPath) {
        super(context, queueInfo);
        String keyPrefix = RedisMessageDao.key(rootPath, queueInfo);
        this.redisClient = new RedisClient(connectionFactory);
        this.waitKey = (keyPrefix + ":wait").getBytes();
        this.doneKey = (keyPrefix + ":done").getBytes();
        this.errorKey = (keyPrefix + ":error").getBytes();
        this.lockKey = (keyPrefix + ":lock").getBytes();
    }

    @Override
    public void push(final Message message) {
        this.redisClient.execute(new PRInvoker<Jedis, Long>(){

            @Override
            public Long invoke(Jedis jedis) throws Exception {
                byte[] data = RedisMessageDao.this.dataSerializer.serialize(message);
                return jedis.hset(RedisMessageDao.this.waitKey, message.getId().getBytes(), data);
            }
        });
    }

    @Override
    protected Message get(final String id) {
        return this.redisClient.execute(new PRInvoker<Jedis, Message>(){

            @Override
            public Message invoke(Jedis jedis) throws Exception {
                byte[] messageByes = jedis.hget(RedisMessageDao.this.waitKey, id.getBytes());
                return (Message)RedisMessageDao.this.dataSerializer.deserialize(messageByes);
            }
        });
    }

    private void complete(final byte[] key, final Message message) {
        this.redisClient.execute(new PRInvoker<Jedis, Boolean>(){

            @Override
            public Boolean invoke(Jedis jedis) throws Exception {
                byte[] data = RedisMessageDao.this.dataSerializer.serialize(message);
                String field = message.getId();
                byte[] fieldBytes = message.getId().getBytes();
                jedis.hset(key, fieldBytes, data);
                jedis.hdel(RedisMessageDao.this.waitKey, (byte[][])new byte[][]{fieldBytes});
                return RedisMessageDao.this.unLock(field);
            }
        });
    }

    @Override
    public void done(Message message) {
        this.complete(this.doneKey, message);
    }

    @Override
    public void error(Message message) {
        this.complete(this.errorKey, message);
    }

    @Override
    public long length() {
        return this.redisClient.execute(new PRInvoker<Jedis, Long>(){

            @Override
            public Long invoke(Jedis jedis) throws Exception {
                return jedis.hlen(RedisMessageDao.this.waitKey);
            }
        });
    }

    @Override
    protected boolean lock(final String id) {
        return this.redisClient.execute(new PRInvoker<Jedis, Boolean>(){

            @Override
            public Boolean invoke(Jedis jedis) throws Exception {
                byte[] value = (System.currentTimeMillis() + "").getBytes();
                return jedis.hsetnx(RedisMessageDao.this.lockKey, id.getBytes(), value) == 1L;
            }
        });
    }

    @Override
    protected boolean unLock(final String id) {
        return this.redisClient.execute(new PRInvoker<Jedis, Boolean>(){

            @Override
            public Boolean invoke(Jedis jedis) throws Exception {
                byte[] value = (System.currentTimeMillis() + "").getBytes();
                return jedis.hdel(RedisMessageDao.this.lockKey, (byte[][])new byte[][]{id.getBytes()}) == 1L;
            }
        });
    }

    @Override
    protected LinkedList<String> queueIdList() {
        return this.redisClient.execute(new PRInvoker<Jedis, LinkedList<String>>(){

            @Override
            public LinkedList<String> invoke(Jedis jedis) throws Exception {
                LinkedList<String> list = new LinkedList<String>();
                Iterator iterator = jedis.hkeys(RedisMessageDao.this.waitKey).iterator();
                while (iterator.hasNext()) {
                    list.add(new String((byte[])iterator.next()));
                }
                return list;
            }
        });
    }
}

