/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.redis;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.queue.MessageDao;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.queue.QueueProvider;
import cn.mzhong.janytask.redis.GenericRedisConnectionFactory;
import cn.mzhong.janytask.redis.RedisConnectionFactory;
import cn.mzhong.janytask.redis.RedisMessageDao;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisProvider
implements QueueProvider {
    static final Logger Log = LoggerFactory.getLogger(RedisProvider.class);
    protected String rootPath = "janytask";
    protected RedisConnectionFactory connectionFactory;
    protected TaskContext context;

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void init(TaskContext context) {
        this.context = context;
        if (this.connectionFactory == null) {
            throw new RuntimeException("\u65e0Redis\u8fde\u63a5\u5de5\u5382\uff0c\u8bf7\u5148\u6307\u5b9aRedis\u8fde\u63a5\u5de5\u5382\uff01");
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this.toString());
        }
    }

    public MessageDao createMessageDao(QueueInfo queueInfo) {
        return new RedisMessageDao(this.context, this.connectionFactory, queueInfo, this.rootPath);
    }

    public String toString() {
        return "RedisProvider{rootPath='" + this.rootPath + '\'' + '}';
    }

    public static RedisProvider create(String hostName, int port) {
        return RedisProvider.create(new JedisPoolConfig(), hostName, port, null, 0, 0);
    }

    public static RedisProvider create(String hostName, int port, String password, int database, int timeout) {
        return RedisProvider.create(new JedisPoolConfig(), hostName, port, password, database, timeout);
    }

    public static RedisProvider create(JedisPoolConfig config, String hostName, int port, String password, int database, int timeout) {
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)config, hostName, port, timeout, password, database);
        return RedisProvider.create(jedisPool);
    }

    public static RedisProvider create(JedisPool jedisPool) {
        RedisProvider provider = new RedisProvider();
        GenericRedisConnectionFactory connectionFactory = new GenericRedisConnectionFactory(jedisPool);
        provider.setConnectionFactory(connectionFactory);
        return provider;
    }
}

