/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.spring;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.producer.TaskProducerFactory;
import cn.mzhong.janytask.producer.TaskProducerInitializer;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class TaskSpringProducerInitializer
extends TaskProducerInitializer {
    ConfigurableListableBeanFactory beanFactory;
    BeanDefinitionRegistry beanDefinitionRegistry;

    public TaskSpringProducerInitializer(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry beanDefinitionRegistry) {
        this.beanFactory = beanFactory;
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    public void init(TaskContext context) {
        Map<Class<?>, Object> producers = context.getProducerMap();
        int index = 0;
        for (Class<?> producerClass : context.getProducerClassSet()) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(TaskProducerFactory.class);
            builder.setFactoryMethod("newInstance");
            builder.addConstructorArgValue((Object)context);
            builder.addConstructorArgValue(producerClass);
            builder.setScope("singleton");
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            beanDefinition.setPrimary(true);
            String beanName = "janytask-producer#" + index++;
            this.beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            producers.put(producerClass, this.beanFactory.getBean(beanName));
            super.processProducer(context, producerClass);
        }
    }
}

