/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    public static final String classpath;
    private static final int cutstart;

    private ClassUtils() {
    }

    private static Set<Class<?>> scanByPackage(String packagePattern, File file) {
        HashSet list = new HashSet();
        for (File children : file.listFiles()) {
            String classpath;
            String _package;
            if (children.isDirectory()) {
                list.addAll(ClassUtils.scanByPackage(packagePattern, children));
                continue;
            }
            if (!children.getName().endsWith(".class") || !(_package = (classpath = children.getParent().substring(cutstart)).replace(File.separator, ".")).matches(packagePattern)) continue;
            String filename = children.getName();
            String classname = _package + "." + filename.substring(0, filename.length() - 6);
            try {
                list.add(Class.forName(classname));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static Set<Class<?>> scanByPackage(String _package) {
        URL classpathUrl = ClassUtils.class.getClassLoader().getResource("");
        File classpathFile = new File(classpathUrl.getFile());
        String packagePattern = _package.replace(".", "\\.");
        packagePattern = packagePattern.replaceAll("\\*{2}", ".+");
        packagePattern = packagePattern.replace("*", "\\S+");
        packagePattern = packagePattern + ".*";
        return ClassUtils.scanByPackage(packagePattern, classpathFile);
    }

    public static Set<Class<?>> scanByAnnotation(String _package, Class<? extends Annotation> ... annotations) {
        HashSet list = new HashSet();
        Set<Class<?>> foundList = ClassUtils.scanByPackage(_package);
        for (Class<?> _class : foundList) {
            for (Class<? extends Annotation> annotation : annotations) {
                if (_class.getAnnotation(annotation) == null) continue;
                list.add(_class);
            }
        }
        return list;
    }

    public static Set<Class<?>> getInterfaces(Class<?> _class) {
        HashSet interfaces = new HashSet();
        Class<?> superclass = _class.getSuperclass();
        if (superclass != null) {
            interfaces.addAll(ClassUtils.getInterfaces(superclass));
        }
        interfaces.addAll(Arrays.asList(_class.getInterfaces()));
        return interfaces;
    }

    public static void main(String[] args) {
        System.out.println(ClassUtils.scanByPackage(""));
    }

    static {
        File classpathFile = new File(ClassUtils.class.getClassLoader().getResource("").getFile());
        classpath = classpathFile.getAbsolutePath();
        cutstart = classpath.length() + 1;
    }
}

