/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.zookeeper;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZookeeperClient
implements Watcher {
    protected ZooKeeper zookeeper;
    CountDownLatch initCountDownLatch = new CountDownLatch(1);

    public ZookeeperClient(String connectString) {
        try {
            this.zookeeper = new ZooKeeper(connectString, 1500, (Watcher)this);
            this.initCountDownLatch.await();
        }
        catch (Exception e) {
            throw new RuntimeException("Zookeeper\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff01", e);
        }
    }

    public boolean create(String path, byte[] data, CreateMode createMode) {
        try {
            this.zookeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
            return true;
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NODEEXISTS) {
                return false;
            }
            if (e.code() == KeeperException.Code.NONODE) {
                String parentPath = path.substring(0, path.lastIndexOf(47));
                this.create(parentPath, null, CreateMode.PERSISTENT);
                return this.create(path, data, createMode);
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String path) {
        try {
            this.zookeeper.delete(path, 0);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5220\u9664Zookeeper\u8def\u5f84\u51fa\u73b0\u9519\u8bef\uff01", e);
        }
    }

    public List<String> getChildren(String path) {
        try {
            return this.zookeeper.getChildren(path, false);
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6Zookeeper\u5b50\u8282\u70b9\u51fa\u9519\uff01", e);
        }
    }

    public byte[] getData(String path) {
        try {
            return this.zookeeper.getData(path, false, null);
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6Zookeeper\u6570\u636e\u51fa\u9519\uff01", e);
        }
    }

    public void process(WatchedEvent watchedEvent) {
        this.initCountDownLatch.countDown();
    }
}

