/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.zookeeper;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.queue.LockedMessageDao;
import cn.mzhong.janytask.queue.Message;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.zookeeper.ZookeeperClient;
import java.util.LinkedList;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZookeeperMessageDao
extends LockedMessageDao {
    static final Logger Log = LoggerFactory.getLogger(ZookeeperMessageDao.class);
    protected String connectString;
    protected ZookeeperClient zkClient;
    protected String waitPath;
    protected String donePath;
    protected String errorPath;
    protected String lockPath;
    protected String rootPath;

    public void initZookeeperClient(String connectString) {
        this.connectString = connectString;
        this.zkClient = new ZookeeperClient(connectString);
    }

    public void initParentPath() {
        String parentPath = this.rootPath + "/" + this.queueInfo.ID();
        this.waitPath = parentPath + "/wait";
        this.donePath = parentPath + "/done";
        this.errorPath = parentPath + "/error";
        this.lockPath = parentPath + "/lock";
        this.zkClient.create(this.waitPath, null, CreateMode.PERSISTENT);
        this.zkClient.create(this.donePath, null, CreateMode.PERSISTENT);
        this.zkClient.create(this.errorPath, null, CreateMode.PERSISTENT);
        this.zkClient.create(this.lockPath, null, CreateMode.PERSISTENT);
    }

    public void initRootPath(String rootPath) {
        this.rootPath = rootPath.startsWith("/") ? rootPath : "/" + rootPath;
    }

    ZookeeperMessageDao(TaskContext context, QueueInfo lineInfo, String connectString, String rootPath) {
        super(context, lineInfo);
        this.initZookeeperClient(connectString);
        this.initRootPath(rootPath);
        this.initParentPath();
    }

    protected void push(String parent, Message message) {
        try {
            byte[] data = this.dataSerializer.serialize(message);
            String path = parent + "/" + message.getId();
            this.zkClient.create(path, data, CreateMode.PERSISTENT);
        }
        catch (Exception e) {
            throw new RuntimeException("\u63a8\u9001\u6d88\u606f\u51fa\u9519\uff01", e);
        }
    }

    protected void delete(String parent, Message message) {
        this.zkClient.delete(parent + "/" + message.getId());
    }

    @Override
    public void push(Message message) {
        this.push(this.waitPath, message);
    }

    @Override
    public void done(Message message) {
        this.push(this.donePath, message);
        this.delete(this.waitPath, message);
        this.unLock(message.getId());
    }

    @Override
    public void error(Message message) {
        this.push(this.errorPath, message);
        this.delete(this.waitPath, message);
        this.unLock(message.getId());
    }

    @Override
    public long length() {
        return this.zkClient.getChildren(this.waitPath).size();
    }

    @Override
    protected boolean lock(String id) {
        return this.zkClient.create(this.lockPath + "/" + id, null, CreateMode.EPHEMERAL);
    }

    @Override
    protected boolean unLock(String id) {
        this.zkClient.delete(this.lockPath + "/" + id);
        return true;
    }

    @Override
    protected Message get(String id) {
        byte[] data = this.zkClient.getData(this.waitPath + "/" + id);
        try {
            return (Message)this.dataSerializer.deserialize(data);
        }
        catch (Exception e) {
            Log.error("\u6d88\u606f\u53cd\u5e8f\u5217\u5316\u51fa\u9519\uff0c\u6d88\u606f\u5df2\u88ab\u5ffd\u7565\uff01\u6d88\u606fID:" + id, (Throwable)e);
            return null;
        }
    }

    @Override
    protected LinkedList<String> queueIdList() {
        return new LinkedList<String>(this.zkClient.getChildren(this.waitPath));
    }
}

