/*
 * Decompiled with CFR 0.152.
 */
package cn.naturemix.framework;

import cn.naturemix.framework.HelperLoader;
import cn.naturemix.framework.bean.Data;
import cn.naturemix.framework.bean.Handler;
import cn.naturemix.framework.bean.Param;
import cn.naturemix.framework.bean.View;
import cn.naturemix.framework.helper.BeanHelper;
import cn.naturemix.framework.helper.ConfigHelper;
import cn.naturemix.framework.helper.ControllerHelper;
import cn.naturemix.framework.util.ArrayUtil;
import cn.naturemix.framework.util.CodecUtil;
import cn.naturemix.framework.util.JsonUtil;
import cn.naturemix.framework.util.ReflectionUtil;
import cn.naturemix.framework.util.StreamUtil;
import cn.naturemix.framework.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(urlPatterns={"/*"}, loadOnStartup=0)
public class DispatcherServlet
extends HttpServlet {
    public void init(ServletConfig servletConfig) throws ServletException {
        HelperLoader.init();
        ServletContext servletContext = servletConfig.getServletContext();
        ServletRegistration jspServlet = servletContext.getServletRegistration("jsp");
        jspServlet.addMapping(new String[]{ConfigHelper.getAppJspPath() + "*"});
        ServletRegistration defaultServlet = servletContext.getServletRegistration("default");
        defaultServlet.addMapping(new String[]{ConfigHelper.getAppAssetPath() + "*"});
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestPath;
        String requestMethod = request.getMethod().toLowerCase();
        Handler handler = ControllerHelper.getHandler(requestMethod, requestPath = request.getPathInfo());
        if (handler != null) {
            Data data;
            Object model;
            Object[] params;
            Class<?> controllerClass = handler.getControllerClass();
            Object controllerBean = BeanHelper.getBean(controllerClass);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String paramValue = request.getParameter(paramName);
                paramMap.put(paramName, paramValue);
            }
            String body = CodecUtil.decodeURL(StreamUtil.getString((InputStream)request.getInputStream()));
            if (StringUtil.isNotEmpty(body) && ArrayUtil.isNotEmpty(params = StringUtil.splitString(body, "&"))) {
                for (Object param : params) {
                    Object[] array = StringUtil.splitString((String)param, "=");
                    if (!ArrayUtil.isNotEmpty(array) || array.length != 2) continue;
                    Object paramName = array[0];
                    Object paramValue = array[1];
                    paramMap.put((String)paramName, paramValue);
                }
            }
            Param param = new Param(paramMap);
            Method actionMethod = handler.getActionMethod();
            Object result = ReflectionUtil.invokeMethod(controllerBean, actionMethod, param);
            if (result instanceof View) {
                View view = (View)result;
                String path = view.getPath();
                if (StringUtil.isNotEmpty(path)) {
                    if (path.startsWith("/")) {
                        response.sendRedirect(request.getContextPath() + path);
                    } else {
                        Map<String, Object> model2 = view.getModel();
                        for (Map.Entry<String, Object> entry : model2.entrySet()) {
                            request.setAttribute(entry.getKey(), entry.getValue());
                        }
                        request.getRequestDispatcher(ConfigHelper.getAppJspPath() + path).forward((ServletRequest)request, (ServletResponse)response);
                    }
                }
            } else if (request instanceof Data && (model = (data = (Data)result).getModel()) != null) {
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                PrintWriter writer = response.getWriter();
                String json = JsonUtil.toJson(model);
                writer.write(json);
                writer.flush();
                writer.close();
            }
        }
    }
}

