/*
 * Decompiled with CFR 0.152.
 */
package cn.naturemix.framework.helper;

import cn.naturemix.framework.annotation.Controller;
import cn.naturemix.framework.annotation.Service;
import cn.naturemix.framework.helper.ConfigHelper;
import cn.naturemix.framework.util.ClassUtil;
import java.util.HashSet;
import java.util.Set;

public final class ClassHelper {
    private static final Set<Class<?>> CLASS_SET;

    public static Set<Class<?>> getClassSet() {
        return CLASS_SET;
    }

    public static Set<Class<?>> getServiceClassSet() {
        HashSet classSet = new HashSet();
        for (Class<?> cls : CLASS_SET) {
            if (!cls.isAnnotationPresent(Service.class)) continue;
            classSet.add(cls);
        }
        return classSet;
    }

    public static Set<Class<?>> getControllerClassSet() {
        HashSet classSet = new HashSet();
        for (Class<?> cls : CLASS_SET) {
            if (!cls.isAnnotationPresent(Controller.class)) continue;
            classSet.add(cls);
        }
        return classSet;
    }

    public static Set<Class<?>> getBeanClassSet() {
        HashSet beanClassSet = new HashSet();
        beanClassSet.addAll(ClassHelper.getServiceClassSet());
        beanClassSet.addAll(ClassHelper.getControllerClassSet());
        return beanClassSet;
    }

    static {
        String basePackage = ConfigHelper.getAppBasePackage();
        CLASS_SET = ClassUtil.getClassSet(basePackage);
    }
}

