/*
 * Decompiled with CFR 0.152.
 */
package cn.naturemix.framework.helper;

import cn.naturemix.framework.util.CollectionUtil;
import cn.naturemix.framework.util.PropsUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseHelper.class);
    private static QueryRunner QUERY_RUNNER;
    private static final ThreadLocal<Connection> CONNECTION_HOLDER;
    private static final BasicDataSource DATA_SOURCE;

    public static Connection getConnection() {
        Connection conn = CONNECTION_HOLDER.get();
        if (conn == null) {
            try {
                conn = DATA_SOURCE.getConnection();
            }
            catch (SQLException e) {
                LOGGER.error("get connection failure", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                CONNECTION_HOLDER.set(conn);
            }
        }
        return conn;
    }

    public static void executeSqlFile(String filePath) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String sql;
            while ((sql = reader.readLine()) != null) {
                DatabaseHelper.executeUpdate(sql, new Object[0]);
            }
        }
        catch (IOException e) {
            LOGGER.error("execute sql file failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String getTableName(Class<?> entityClass) {
        return entityClass.getSimpleName().toLowerCase();
    }

    public static <T> List<T> queryEntityList(Class<T> entityClass, String sql, Object ... params) {
        List entityList;
        try {
            Connection conn = DatabaseHelper.getConnection();
            entityList = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new BeanListHandler(entityClass), params);
        }
        catch (SQLException e) {
            LOGGER.error("query entity list failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return entityList;
    }

    public static <T> T queryEntity(Class<T> entityClass, String sql, Object ... params) {
        Object entity;
        try {
            Connection conn = DatabaseHelper.getConnection();
            entity = QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new BeanHandler(entityClass), params);
        }
        catch (SQLException e) {
            LOGGER.error("query entity failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return (T)entity;
    }

    public static List<Map<String, Object>> executeQuery(String sql, Object ... params) {
        List result;
        try {
            Connection conn = DatabaseHelper.getConnection();
            result = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new MapListHandler(), params);
        }
        catch (Exception e) {
            LOGGER.error("execute query failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return result;
    }

    public static int executeUpdate(String sql, Object ... params) {
        int rows = 0;
        try {
            Connection conn = DatabaseHelper.getConnection();
            rows = QUERY_RUNNER.update(conn, sql, params);
        }
        catch (SQLException e) {
            LOGGER.error("execute update failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return rows;
    }

    public static <T> boolean insertEntity(Class<T> entityClass, Map<String, Object> fieldMap) {
        if (CollectionUtil.isEmpty(fieldMap)) {
            LOGGER.error("can not insert entity: fieldMap is empty");
            return false;
        }
        String sql = "INSERT INTO " + DatabaseHelper.getTableName(entityClass);
        StringBuilder columns = new StringBuilder("(");
        StringBuilder values = new StringBuilder("(");
        for (String fieldName : fieldMap.keySet()) {
            columns.append(fieldName).append(",");
            values.append("?,");
        }
        columns.replace(columns.lastIndexOf(","), columns.length(), ")");
        values.replace(values.lastIndexOf(","), values.length(), ")");
        sql = sql + columns + "VALUES" + values;
        System.out.print(sql);
        Object[] params = fieldMap.values().toArray();
        return DatabaseHelper.executeUpdate(sql, params) == 1;
    }

    public static <T> boolean updateEntity(Class<T> entityClass, long id, Map<String, Object> fieldMap) {
        if (CollectionUtil.isEmpty(fieldMap)) {
            LOGGER.error("can not update entity: fieldMap is empty");
            return false;
        }
        String sql = "UPDATE " + DatabaseHelper.getTableName(entityClass) + " SET ";
        StringBuilder columns = new StringBuilder();
        for (String fieldName : fieldMap.keySet()) {
            columns.append(fieldName).append("=?, ");
        }
        sql = sql + columns.substring(0, columns.lastIndexOf(",")) + "WHERE id=?";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.addAll(fieldMap.values());
        paramList.add(id);
        Object[] params = paramList.toArray();
        return DatabaseHelper.executeUpdate(sql, params) == 1;
    }

    public static <T> boolean deleteEntity(Class<T> entityClass, long id) {
        String sql = "DELETE FROM " + DatabaseHelper.getTableName(entityClass) + " WHERE id=?";
        return DatabaseHelper.executeUpdate(sql, id) == 1;
    }

    static {
        CONNECTION_HOLDER = new ThreadLocal();
        QUERY_RUNNER = new QueryRunner();
        Properties conf = PropsUtil.loadProps("config.properties");
        String DRIVER = conf.getProperty("jdbc.driver");
        String URL2 = conf.getProperty("jdbc.url");
        String USERNAME = conf.getProperty("jdbc.username");
        String PASSWORD = conf.getProperty("jdbc.password");
        DATA_SOURCE = new BasicDataSource();
        DATA_SOURCE.setDriverClassName(DRIVER);
        DATA_SOURCE.setUrl(URL2);
        DATA_SOURCE.setUsername(USERNAME);
        DATA_SOURCE.setPassword(PASSWORD);
        try {
            Class.forName(DRIVER);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("can not load jdbc driver ", (Throwable)e);
        }
    }
}

