/*
 * Decompiled with CFR 0.152.
 */
package cn.naturemix.framework.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> String toJson(T obj) {
        String json;
        try {
            json = OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            LOGGER.error("convert POJO to JSON failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return json;
    }

    public static <T> T fromJson(String json, Class<T> type) {
        Object pojo;
        try {
            pojo = OBJECT_MAPPER.readValue(json, type);
        }
        catch (Exception e) {
            LOGGER.error("convert JSON to POJO failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return (T)pojo;
    }
}

