package cn.naturemix.framework;

import cn.naturemix.framework.helper.BeanHelper;
import cn.naturemix.framework.helper.ClassHelper;
import cn.naturemix.framework.helper.ControllerHelper;
import cn.naturemix.framework.helper.IocHelper;
import cn.naturemix.framework.util.ClassUtil;

/**
 * 加载相应的 Helper 类
 *
 * @author flytoyou
 * @version 1.0.0
 */
public final class HelperLoader {

    public static void init() {
        Class<?>[]  classList = new Class[]{
                ClassHelper.class,
                BeanHelper.class,
                IocHelper.class,
                ControllerHelper.class
        };
        for (Class<?> cls : classList){
            ClassUtil.loadClass(cls.getName());
        }
    }
}
