/*
 * Decompiled with CFR 0.152.
 */
package com.dfsx.library.zookeeperconfig;

import com.dfsx.library.zookeeperconfig.DataMonitorListener;
import com.dfsx.library.zookeeperconfig.ZookeeperOperation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EventLoop {
    protected ZookeeperOperation operation;
    protected DataMonitorListener listener;
    protected Map<String, Boolean> pathToStartedMap;
    protected Map<String, Boolean> pathToValidMap;

    public EventLoop(ZookeeperOperation operation, DataMonitorListener listener) {
        this.operation = operation;
        this.listener = listener;
        this.pathToStartedMap = new ConcurrentHashMap<String, Boolean>(10);
        this.pathToValidMap = new ConcurrentHashMap<String, Boolean>(10);
    }

    public Map<String, Boolean> getPathToStartedMap() {
        return this.pathToStartedMap;
    }

    public Map<String, Boolean> getPathToValidMap() {
        return this.pathToValidMap;
    }

    public ZookeeperOperation getOperation() {
        return this.operation;
    }

    public abstract void start(String var1);

    public void stop(String path) {
        if (this.pathToStartedMap.containsKey(path) && this.pathToStartedMap.get(path).booleanValue()) {
            this.pathToStartedMap.put(path, false);
        }
    }
}

