/*
 * Decompiled with CFR 0.152.
 */
package com.dfsx.library.zookeeperconfig;

import com.dfsx.library.zookeeperconfig.DataMonitorListener;
import com.dfsx.library.zookeeperconfig.EventLoop;
import com.dfsx.library.zookeeperconfig.FuncType;
import com.dfsx.library.zookeeperconfig.GetChildrenEventLoop;
import com.dfsx.library.zookeeperconfig.GetDataEventLoop;
import com.dfsx.library.zookeeperconfig.ZookeeperOperation;
import java.util.Map;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistsEventLoop
extends EventLoop
implements Watcher,
AsyncCallback.StatCallback {
    private static Logger log = LoggerFactory.getLogger(ExistsEventLoop.class);
    private GetDataEventLoop getDataEventLoop;
    private GetChildrenEventLoop getChildrenEventLoop;

    public ExistsEventLoop(ZookeeperOperation operation, DataMonitorListener listener) {
        super(operation, listener);
        this.getDataEventLoop = new GetDataEventLoop(operation, listener);
        this.getChildrenEventLoop = new GetChildrenEventLoop(operation, listener);
    }

    public GetDataEventLoop getGetDataEventLoop() {
        return this.getDataEventLoop;
    }

    public GetChildrenEventLoop getGetChildrenEventLoop() {
        return this.getChildrenEventLoop;
    }

    public synchronized void run(String path, FuncType funcType) {
        Map<String, Boolean> startedMap = this.getPathToStartedMap();
        Map<String, Boolean> validMap = this.getPathToValidMap();
        if (!startedMap.containsKey(path)) {
            startedMap.put(path, false);
        }
        if (!validMap.containsKey(path)) {
            validMap.put(path, false);
        }
        if (funcType == FuncType.GETDATA) {
            startedMap = this.getDataEventLoop.getPathToStartedMap();
            validMap = this.getDataEventLoop.getPathToValidMap();
            if (!startedMap.containsKey(path)) {
                startedMap.put(path, false);
            }
            if (!validMap.containsKey(path)) {
                validMap.put(path, false);
            }
        } else if (funcType == FuncType.GETCHILDREN) {
            startedMap = this.getChildrenEventLoop.getPathToStartedMap();
            validMap = this.getChildrenEventLoop.getPathToValidMap();
            if (!startedMap.containsKey(path)) {
                startedMap.put(path, false);
            }
            if (!validMap.containsKey(path)) {
                validMap.put(path, false);
            }
        }
        this.start(path);
    }

    @Override
    public void start(String path) {
        Map<String, Boolean> getDataEventLoopPathToStartedMap = this.getDataEventLoop.getPathToStartedMap();
        Map<String, Boolean> getChildrenEventLoopPathToStartedMap = this.getChildrenEventLoop.getPathToStartedMap();
        if (!((Boolean)this.pathToStartedMap.get(path)).booleanValue() || getDataEventLoopPathToStartedMap.containsKey(path) && !getDataEventLoopPathToStartedMap.get(path).booleanValue() || getChildrenEventLoopPathToStartedMap.containsKey(path) && !getChildrenEventLoopPathToStartedMap.get(path).booleanValue()) {
            this.operation.exists(path, this, this);
        }
    }

    @Override
    public void stop(String path) {
        super.stop(path);
    }

    public void process(WatchedEvent watchedEvent) {
        log.info("process received event:" + watchedEvent.toString());
        String path = watchedEvent.getPath();
        switch (watchedEvent.getType()) {
            case None: {
                switch (watchedEvent.getState()) {
                    case Expired: 
                    case Disconnected: {
                        log.warn("expired or disconnected");
                        break;
                    }
                    case SyncConnected: {
                        log.info("connected");
                    }
                }
                break;
            }
            case NodeDataChanged: 
            case NodeCreated: {
                this.operation.exists(path, this, this);
                break;
            }
            case NodeDeleted: {
                this.operation.exists(path, this, this);
                this.getDataEventLoop.stop(path);
                this.getChildrenEventLoop.stop(path);
            }
        }
    }

    public void processResult(int rc, String path, Object ctx, Stat stat) {
        boolean exists;
        log.info("processResult: rc:" + rc + ", path:" + path + ", exist:" + (stat != null ? "true" : "false"));
        switch (KeeperException.Code.get((int)rc)) {
            case OK: {
                exists = true;
                break;
            }
            case NONODE: {
                exists = false;
                break;
            }
            case SESSIONEXPIRED: 
            case NOAUTH: {
                this.getOperation().setDead(true);
                return;
            }
            default: {
                return;
            }
        }
        if (!((Boolean)this.pathToStartedMap.get(path)).booleanValue()) {
            this.pathToStartedMap.put(path, true);
        }
        this.listener.updateExistsMap(path, exists);
        if (!((Boolean)this.pathToValidMap.get(path)).booleanValue()) {
            this.pathToValidMap.put(path, true);
        }
        if (exists) {
            Map<String, Boolean> startedMap = this.getDataEventLoop.getPathToStartedMap();
            if (startedMap.containsKey(path)) {
                this.getDataEventLoop.start(path);
            }
            if ((startedMap = this.getChildrenEventLoop.getPathToStartedMap()).containsKey(path)) {
                this.getChildrenEventLoop.start(path);
            }
        } else {
            Map<String, Boolean> startedMap = this.getDataEventLoop.getPathToStartedMap();
            if (startedMap.containsKey(path)) {
                this.getDataEventLoop.getPathToValidMap().put(path, true);
            }
            if ((startedMap = this.getChildrenEventLoop.getPathToStartedMap()).containsKey(path)) {
                this.getChildrenEventLoop.getPathToValidMap().put(path, true);
            }
        }
    }
}

