/*
 * Decompiled with CFR 0.152.
 */
package com.dfsx.library.zookeeperconfig;

import com.dfsx.library.zookeeperconfig.DataMonitorListener;
import com.dfsx.library.zookeeperconfig.EventLoop;
import com.dfsx.library.zookeeperconfig.ZookeeperOperation;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetChildrenEventLoop
extends EventLoop
implements Watcher,
AsyncCallback.ChildrenCallback {
    private static Logger log = LoggerFactory.getLogger(GetChildrenEventLoop.class);

    public GetChildrenEventLoop(ZookeeperOperation operation, DataMonitorListener listener) {
        super(operation, listener);
    }

    @Override
    public void start(String path) {
        if (!((Boolean)this.pathToStartedMap.get(path)).booleanValue()) {
            this.operation.getChildren(path, this, this);
        }
    }

    @Override
    public void stop(String path) {
        super.stop(path);
        this.listener.updateChildrenMap(path, null);
    }

    public void process(WatchedEvent watchedEvent) {
        log.info("process received event:" + watchedEvent.toString());
        String path = watchedEvent.getPath();
        switch (watchedEvent.getType()) {
            case None: {
                switch (watchedEvent.getState()) {
                    case Expired: 
                    case Disconnected: {
                        log.warn("expired or disconnected");
                        break;
                    }
                    case SyncConnected: {
                        log.info("connected");
                    }
                }
                break;
            }
            case NodeDeleted: {
                this.stop(path);
                break;
            }
            case NodeChildrenChanged: {
                this.operation.getChildren(path, this, this);
            }
        }
    }

    public void processResult(int rc, String path, Object ctx, List<String> children) {
        boolean exists;
        log.info("processResult: rc:" + rc + ", path:" + path + ", children:" + children);
        switch (KeeperException.Code.get((int)rc)) {
            case OK: {
                exists = true;
                break;
            }
            case NONODE: {
                exists = false;
                break;
            }
            case SESSIONEXPIRED: 
            case NOAUTH: {
                return;
            }
            default: {
                return;
            }
        }
        if (exists) {
            if (!((Boolean)this.pathToStartedMap.get(path)).booleanValue()) {
                this.pathToStartedMap.put(path, true);
            }
            this.listener.updateChildrenMap(path, children);
            if (!((Boolean)this.pathToValidMap.get(path)).booleanValue()) {
                this.pathToValidMap.put(path, true);
            }
        }
    }
}

