/*
 * Decompiled with CFR 0.152.
 */
package com.dfsx.library.zookeeperconfig;

import com.dfsx.library.zookeeperconfig.ZooKeeperConfigImpl;
import com.dfsx.library.zookeeperconfig.ZooKeeperSetFlag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConfig {
    private static Logger log = LoggerFactory.getLogger(ZooKeeperConfig.class);
    private String connectString;
    private int sessionTimeout;
    private ZooKeeperConfigImpl zooKeeperConfigImpl;

    public ZooKeeperConfig(String connectString, int sessionTimeout) {
        this.connectString = connectString;
        this.sessionTimeout = sessionTimeout;
        this.zooKeeperConfigImpl = new ZooKeeperConfigImpl(connectString, sessionTimeout);
    }

    private synchronized void tryToConnect() {
        if (!this.zooKeeperConfigImpl.isOk()) {
            log.info("try to connect, create new instance");
            this.zooKeeperConfigImpl = new ZooKeeperConfigImpl(this.connectString, this.sessionTimeout);
        }
    }

    public boolean exists(String path) throws Exception {
        this.tryToConnect();
        return this.zooKeeperConfigImpl.exists(path);
    }

    public String get(String path) throws Exception {
        this.tryToConnect();
        return this.zooKeeperConfigImpl.get(path);
    }

    public String set(String path, String value, ZooKeeperSetFlag flag) throws Exception {
        this.tryToConnect();
        return this.zooKeeperConfigImpl.set(path, value, flag);
    }

    public List<String> getChildPaths(String path) throws Exception {
        this.tryToConnect();
        return this.zooKeeperConfigImpl.getChildPaths(path);
    }

    public void printMap() {
        this.zooKeeperConfigImpl.printMap();
    }
}

