/*
 * Decompiled with CFR 0.152.
 */
package com.dfsx.library.zookeeperconfig;

import com.dfsx.library.zookeeperconfig.ConnectionDeadRuntimeException;
import com.dfsx.library.zookeeperconfig.DataMonitorListener;
import com.dfsx.library.zookeeperconfig.ExistsEventLoop;
import com.dfsx.library.zookeeperconfig.FuncType;
import com.dfsx.library.zookeeperconfig.WaitTimedOutRuntimeException;
import com.dfsx.library.zookeeperconfig.ZNodeNotExistRuntimeException;
import com.dfsx.library.zookeeperconfig.ZooKeeperSetFlag;
import com.dfsx.library.zookeeperconfig.ZookeeperOperation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConfigImpl
implements DataMonitorListener {
    private static Logger log = LoggerFactory.getLogger(ZooKeeperConfigImpl.class);
    private Map<String, Boolean> pathToExistsMap = new ConcurrentHashMap<String, Boolean>(10);
    private Map<String, String> pathToValueMap = new ConcurrentHashMap<String, String>(10);
    private Map<String, List<String>> pathToChildPathsMap = new ConcurrentHashMap<String, List<String>>(10);
    private ExistsEventLoop eventLoop;

    public ZooKeeperConfigImpl(String connectString, int sessionTimeout) {
        this.eventLoop = new ExistsEventLoop(new ZookeeperOperation(connectString, sessionTimeout), this);
    }

    public boolean isOk() {
        return !this.eventLoop.getOperation().isDead();
    }

    public void close() {
        this.eventLoop.getOperation().close();
    }

    public boolean exists(String path) throws Exception {
        if (!this.isOk()) {
            throw new ConnectionDeadRuntimeException("ZooKeeper connection is dead");
        }
        this.eventLoop.run(path, FuncType.EXISTS);
        Map<String, Boolean> validMap = this.eventLoop.getPathToValidMap();
        int count = 0;
        while (!validMap.get(path).booleanValue() || !this.isOk()) {
            try {
                Thread.sleep(10L);
                if (++count < 500 && this.isOk()) continue;
                throw new WaitTimedOutRuntimeException("Waiting for exists map valid timed out");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!this.pathToExistsMap.containsKey(path)) {
            return false;
        }
        return this.pathToExistsMap.get(path);
    }

    public String get(String path) throws Exception {
        if (!this.isOk()) {
            throw new ConnectionDeadRuntimeException("ZooKeeper connection is dead");
        }
        this.eventLoop.run(path, FuncType.GETDATA);
        Map<String, Boolean> validMap = this.eventLoop.getGetDataEventLoop().getPathToValidMap();
        int count = 0;
        while (!validMap.get(path).booleanValue() || !this.isOk()) {
            try {
                Thread.sleep(10L);
                if (++count < 500 && this.isOk()) continue;
                throw new WaitTimedOutRuntimeException("Waiting for value map valid timed out");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!this.pathToValueMap.containsKey(path)) {
            throw new ZNodeNotExistRuntimeException("znode: " + path + " is not exist");
        }
        return this.pathToValueMap.get(path);
    }

    public String set(String path, String value, ZooKeeperSetFlag flag) throws Exception {
        if (!this.isOk()) {
            throw new ConnectionDeadRuntimeException("ZooKeeper connection is dead");
        }
        return this.eventLoop.getOperation().setData(path, value, flag);
    }

    public List<String> getChildPaths(String path) throws Exception {
        if (!this.isOk()) {
            throw new ConnectionDeadRuntimeException("ZooKeeper connection is dead");
        }
        this.eventLoop.run(path, FuncType.GETCHILDREN);
        Map<String, Boolean> validMap = this.eventLoop.getGetChildrenEventLoop().getPathToValidMap();
        int count = 0;
        while (!validMap.get(path).booleanValue() || !this.isOk()) {
            try {
                Thread.sleep(10L);
                if (++count < 500 && this.isOk()) continue;
                throw new WaitTimedOutRuntimeException("Waiting for children map valid timed out");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!this.pathToChildPathsMap.containsKey(path)) {
            throw new ZNodeNotExistRuntimeException("znode: " + path + " is not exist");
        }
        return this.pathToChildPathsMap.get(path);
    }

    @Override
    public void updateExistsMap(String path, boolean exist) {
        this.pathToExistsMap.put(path, exist);
    }

    @Override
    public void updateValueMap(String path, byte[] data) {
        if (data == null) {
            if (this.pathToValueMap.containsKey(path)) {
                this.pathToValueMap.remove(path);
            }
        } else {
            this.pathToValueMap.put(path, new String(data));
        }
    }

    @Override
    public void updateChildrenMap(String path, List<String> children) {
        if (children == null) {
            if (this.pathToChildPathsMap.containsKey(path)) {
                this.pathToChildPathsMap.remove(path);
            }
        } else {
            this.pathToChildPathsMap.put(path, children);
        }
    }

    public void printMap() {
        log.debug("data->started:" + this.eventLoop.getGetDataEventLoop().getPathToStartedMap());
        log.debug("child->started:" + this.eventLoop.getGetChildrenEventLoop().getPathToStartedMap());
        log.debug("path->exists:" + this.pathToExistsMap);
        log.debug("path->value:" + this.pathToValueMap);
        log.debug("path->children:" + this.pathToChildPathsMap);
    }
}

