/*
 * Decompiled with CFR 0.152.
 */
package com.dfsx.library.zookeeperconfig;

import com.dfsx.library.zookeeperconfig.ZooKeeperSetFlag;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperOperation
implements Watcher {
    private static Logger log = LoggerFactory.getLogger(ZookeeperOperation.class);
    private String connectString;
    private int sessionTimeout;
    private boolean isDead;
    private ZooKeeper zooKeeper;

    public ZookeeperOperation(String connectString, int sessionTimeout) {
        this.connectString = connectString;
        this.sessionTimeout = sessionTimeout;
        this.isDead = false;
        this.zooKeeper = this.createZooKeeper();
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean dead) {
        this.isDead = dead;
    }

    private ZooKeeper createZooKeeper() {
        ZooKeeper zooKeeper = null;
        try {
            zooKeeper = new ZooKeeper(this.connectString, this.sessionTimeout, (Watcher)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zooKeeper;
    }

    public void close() {
        try {
            this.zooKeeper.close();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return null != this.zooKeeper.exists(path, watcher);
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb) {
        this.zooKeeper.exists(path, watcher, cb, null);
    }

    public String getData(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return new String(this.zooKeeper.getData(path, watcher, null));
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb) {
        this.zooKeeper.getData(path, watcher, cb, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String setData(String path, String value, ZooKeeperSetFlag flag) {
        String retval;
        block15: {
            retval = path;
            try {
                switch (flag) {
                    case CREATE: {
                        return this.zooKeeper.create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    case CREATE_TEMPORARY: {
                        return this.zooKeeper.create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                    }
                    case OVERWRITE: {
                        this.zooKeeper.setData(path, value.getBytes(), -1);
                        return retval;
                    }
                    case OVERWRITE_IF_EXISTS: {
                        break block15;
                    }
                    case SEQUENTIAL: {
                        return this.zooKeeper.create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                    }
                    case SEQUENTIAL_TEMPORARY: {
                        return this.zooKeeper.create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
                    }
                }
                return retval;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return retval;
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
            return retval;
        }
        while (true) {
            try {
                if (this.zooKeeper.exists(path, false) == null) return this.zooKeeper.create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                this.zooKeeper.setData(path, value.getBytes(), -1);
                return retval;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (KeeperException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.zooKeeper.getChildren(path, watcher, null);
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb) {
        this.zooKeeper.getChildren(path, watcher, cb, null);
    }

    public void process(WatchedEvent watchedEvent) {
        log.info("process received event:" + watchedEvent.toString());
        block0 : switch (watchedEvent.getType()) {
            case None: {
                switch (watchedEvent.getState()) {
                    case Expired: 
                    case Disconnected: {
                        log.warn("expired or disconnected");
                        this.close();
                        this.isDead = true;
                        break block0;
                    }
                    case SyncConnected: {
                        log.info("connected");
                    }
                }
            }
        }
    }
}

