/*
 * Decompiled with CFR 0.152.
 */
package cn.net.mugui.jsonbean.strengthen;

import com.alibaba.fastjson.JSONArray;
import com.mugui.bean.JsonBean;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonBeanUtil {
    public static <T extends JsonBean> List<T> parseArray(String data, Class<T> channelGoodsReqClass) {
        return JsonBeanUtil.parseArray(JSONArray.parseArray(data), channelGoodsReqClass);
    }

    public static <T extends JsonBean> List<T> parseArray(JSONArray data, Class<T> channelGoodsReqClass) {
        LinkedList<T> list = new LinkedList<T>();
        Iterator<Object> iterator = data.iterator();
        while (iterator.hasNext()) {
            list.add(JsonBean.newBean(channelGoodsReqClass, iterator.next()));
        }
        return list;
    }

    public static <T extends List<? extends JsonBean>> JSONArray getImplicitJson(T reqs) {
        JSONArray array = new JSONArray();
        reqs.forEach(key -> array.add(key.get()));
        return array;
    }

    public static <T extends JsonBean, R extends JsonBean> void fieldTypeRepair(T req, String fieldName, Class<R> fieldClass) {
        Object o = req.get(fieldName);
        if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                JsonBean r = (JsonBean)JsonBean.newBean(fieldClass, entry.getValue());
                entry.setValue(r);
            }
        } else if (o instanceof Collection) {
            Iterator iterator = ((Collection)o).iterator();
            JSONArray jSONArray = new JSONArray();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                jSONArray.add(JsonBean.newBean(fieldClass, next));
            }
            req.set(fieldName, jSONArray);
        }
    }
}

