package com.mugui.base.client.net.bagsend;

import com.mugui.base.base.Autowired;
import com.mugui.base.base.Component;
import com.mugui.base.client.net.baghandle.NetHandle;
import com.mugui.base.client.net.bean.Message;
import com.mugui.base.client.net.bean.NetBag;
import com.mugui.base.client.net.classutil.DataSave;
import com.mugui.base.util.Other;

import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.HashMap;

import cn.hutool.core.codec.Base64;

@Component
public class BagSend {
	private String server;

	@Autowired
	private NetHandle netHandle;

	private String setSession(String session) {
//        SharedPreferences mugui = DataSave.app.getBaseContext().getSharedPreferences("mugui", Context.MODE_PRIVATE);
//        mugui.edit().putString("session", session).commit();
		return session;
	}

	private String getSession() {
//        SharedPreferences mugui = DataSave.app.getBaseContext().getSharedPreferences("mugui", Context.MODE_PRIVATE);
//        String session = mugui.getString("session", null);
//        return session;
		return null;
	}

	private HashMap<String, String> sessionhead = new HashMap<>();

	private String http_server;
	private String ws_server;

	public void init() {
		http_server = "http://" + server + "/";
		ws_server = "ws://" + server + "/";
	}

	public void setServerUrl(String url) {
		server = url;
		init();
	}

	@Autowired
	private BagSendTask bagSendTask;

	public NetCall sendBag(NetBag bag, File... file) {

		NetCall netCall = new NetCall();
		bagSendTask.add(new Runnable() {
			@Override
			public void run() {
				bag.setHash(Other.MD5(bag.toString()));
				bag.setSession(getSession());
				String post = null;
				try {
					if (file.length > 0) {
						post = HTTPUtil.post(http_server, sessionhead, bag.toJson(), file);
					} else {
						post = HTTPUtil.post(http_server, sessionhead, bag.toString());
					}
					if (post == null) {
						throw new RuntimeException(http_server + " bag:" + bag + "访问错误");
					}
				} catch (Exception e) {
					Message message = new Message();
					message.setDate(e.getMessage());
					message.setMsg("服务器出错了");
					message.setType(500);
					bag.setData(message);
					post = bag.toString();
				}
				NetBag bag2 = NetBag.newBean(NetBag.class, post);
				if (StringUtils.isNotBlank(bag2.getSession()))
					sessionhead.put("Cookie", "SESSION=" + (setSession(Base64.encode(bag2.getSession()))) + "");
				System.out.println("处理结果: " + netHandle.httpHandle(bag2, netCall));
			}
		});
		return netCall;
	}

	public NetCall sendData(String func) {
		return sendData(func, null);
	}

	public NetCall sendData(String func, Object data) {
		NetBag bag = new NetBag();
		bag.setFunc(func).setData(data);
		return sendBag(bag);
	}

	public NetCall sendData(String func, Object data, File file) {
		NetBag bag = new NetBag();
		bag.setFunc(func).setData(data);
		return sendBag(bag, file);
	}

	public NetCall subWs(String func, Object data) {
		NetCall netCall = WSUtil.subNetCall(func);
		ws("sub." + func, null);
		return netCall;

	}

	public NetCall subWs(String func) {
		return subWs(func, null);
	}

	public void unsubWs(String func) {
		WSUtil.unsubNetCall(func);
		ws("unsub." + func, null);
	}

	@Autowired
	private WsHandle wsHandle;

	private void ws(String type_func, Object data) {
		bagSendTask.add(new Runnable() {
			@Override
			public void run() {
				NetBag bag = new NetBag();
				bag.setFunc(type_func);
				bag.setData(data);
				bag.setHash(Other.MD5(bag.toString()));
				bag.setSession(Base64.decodeStr(getSession()));
				WSUtil.ws(ws_server, sessionhead, bag.toString(), wsHandle);
			}
		});
	}

}
