package com.mugui.base.client.net.bagsend;


import com.mugui.base.base.Autowired;
import com.mugui.base.base.Component;
import com.mugui.base.client.net.baghandle.NetHandle;
import com.mugui.base.client.net.bean.NetBag;

import java.nio.charset.Charset;

import lombok.Getter;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

@Component
public class WsHandle extends WebSocketListener {
	@Getter
	private WebSocket socket = null;

	@Autowired
	private NetHandle handle;

	@Override
	public void onOpen(WebSocket webSocket, Response response) {
		System.out.println("WebSocketListener->>onOpen");
		socket = webSocket;
	}

	@Override
	public void onMessage(WebSocket webSocket, ByteString bytes) {
		onMessage(webSocket, bytes.string(Charset.forName("UTF-8")));
	}

	@Override
	public void onMessage(WebSocket webSocket, String text) {
		handle.WsHandle(NetBag.newBean(NetBag.class, text));
	}

	@Override
	public void onFailure(WebSocket webSocket, Throwable t, Response response) {
		System.out.println("WebSocketListener->>onFailure ");
		try {
			socket = null;
			throw t;
		} catch (Throwable e) {
			e.printStackTrace();
		}

	}
}
