package com.mugui.base.client.net.bagsend;

import com.mugui.base.base.Component;
import com.mugui.base.client.net.auto.AutoTask;
import com.mugui.base.client.net.base.Task;
import com.mugui.base.client.net.base.TaskInterface;
import com.mugui.base.client.net.task.TaskManager;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * 包消息发送处理器
 */
@Task(value = Task.DEFAULT, time = 0)
@AutoTask
@Component
public class BagSendTask implements TaskInterface {

    public void init() {
        System.out.println(BagSendTask.class.getName() + "初始化");
    }

    byte[] lock = new byte[0];

   // ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(5);
    @Override
    public void run() {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                throwable.printStackTrace();
                TaskManager.getTaskManager().add(new BagSendTask());
            }
        });
        while (true) {
            try {
                Runnable poll = null;
                synchronized (lock) {
                    poll = queue.poll();
                    if (poll == null) {
                        lock.wait();
                        continue;
                    }
                }
                poll.run();
                //scheduledExecutorService.execute(poll);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue<>();

    public void add(Runnable runnable) {
        synchronized (lock) {
            queue.add(runnable);
            lock.notifyAll();
        }
    }
}
