package com.mugui.base.client.net.bagsend;


import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import okhttp3.Request.Builder;

public class WSUtil {

	public static void ws(String ws_server, HashMap<String, String> sessionhead, String string, WsHandle wsHandle) {
		if (wsHandle.getSocket() == null) {
			synchronized (WSUtil.class) {
				if (wsHandle.getSocket() == null) {
					OkHttpClient okHttpClient = new OkHttpClient.Builder().readTimeout(10, TimeUnit.SECONDS)
							.writeTimeout(10, TimeUnit.SECONDS).connectTimeout(10, TimeUnit.SECONDS).build();
					Builder builder = new Builder();
					Set<Entry<String, String>> entrySet = sessionhead.entrySet();
					for (Entry<String, String> entry : entrySet) {
						if (StringUtils.isNotBlank(entry.getKey()) && StringUtils.isNotBlank(entry.getValue()))
							builder.addHeader(entry.getKey(), entry.getValue());
					}
					okHttpClient.newWebSocket(builder.url(ws_server).build(), wsHandle);
					okHttpClient.dispatcher().executorService().shutdown();
				}
			}
		}
		wsHandle.getSocket().send(string);
	}
	private static HashMap<String, NetCall> wsNetCalls = new HashMap<>();

	public static NetCall getWsNetCall(String func){
		return wsNetCalls.get(func);
	}
	public static NetCall subNetCall(String func){
		NetCall netCall=null;
		synchronized (wsNetCalls) {
			netCall = wsNetCalls.get(func);
			if (netCall == null) {
				netCall = new NetCall();
				wsNetCalls.put(func, netCall);
			}
		}
		return wsNetCalls.get(func);
	}

	public static void unsubNetCall(String func) {
		synchronized (wsNetCalls) {
			wsNetCalls.remove(func);
		}
	}
}
