/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.impl.AbstractCache;
import cn.hutool.cache.impl.CacheObj;
import java.util.HashMap;
import java.util.Iterator;

public class LFUCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;

    public LFUCache(int capacity) {
        this(capacity, 0L);
    }

    public LFUCache(int capacity, long timeout2) {
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout2;
        this.cacheMap = new HashMap(capacity + 1, 1.0f);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObj comin = null;
        Iterator values2 = this.cacheMap.values().iterator();
        while (values2.hasNext()) {
            CacheObj co = (CacheObj)values2.next();
            if (co.isExpired()) {
                values2.remove();
                this.onRemove(co.key, co.obj);
                ++count;
                continue;
            }
            if (comin != null && co.accessCount >= comin.accessCount) continue;
            comin = co;
        }
        if (this.isFull() && comin != null) {
            long minAccessCount = comin.accessCount;
            values2 = this.cacheMap.values().iterator();
            while (values2.hasNext()) {
                CacheObj co1 = (CacheObj)values2.next();
                co1.accessCount -= minAccessCount;
                if (co1.accessCount > 0L) continue;
                values2.remove();
                this.onRemove(co1.key, co1.obj);
                ++count;
            }
        }
        return count;
    }
}

