/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.GlobalPruneTimer;
import cn.hutool.cache.impl.AbstractCache;
import cn.hutool.cache.impl.CacheObj;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;

public class TimedCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;
    private ScheduledFuture<?> pruneJobFuture;

    public TimedCache(long timeout2) {
        this(timeout2, new HashMap());
    }

    public TimedCache(long timeout2, Map<K, CacheObj<K, V>> map) {
        this.capacity = 0;
        this.timeout = timeout2;
        this.cacheMap = map;
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        Iterator values2 = this.cacheMap.values().iterator();
        while (values2.hasNext()) {
            CacheObj co = (CacheObj)values2.next();
            if (!co.isExpired()) continue;
            values2.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }

    public void schedulePrune(long delay) {
        this.pruneJobFuture = GlobalPruneTimer.INSTANCE.schedule(this::prune, delay);
    }

    public void cancelPruneSchedule() {
        if (null != this.pruneJobFuture) {
            this.pruneJobFuture.cancel(true);
        }
    }
}

