/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Base62Codec;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class Base62 {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private static final Base62Codec codec = Base62Codec.createGmp();

    public static String encode(CharSequence source2) {
        return Base62.encode(source2, DEFAULT_CHARSET);
    }

    public static String encode(CharSequence source2, Charset charset) {
        return Base62.encode(StrUtil.bytes(source2, charset));
    }

    public static String encode(byte[] source2) {
        return new String(codec.encode(source2));
    }

    public static String encode(InputStream in) {
        return Base62.encode(IoUtil.readBytes(in));
    }

    public static String encode(File file) {
        return Base62.encode(FileUtil.readBytes(file));
    }

    public static String decodeStrGbk(CharSequence source2) {
        return Base62.decodeStr(source2, CharsetUtil.CHARSET_GBK);
    }

    public static String decodeStr(CharSequence source2) {
        return Base62.decodeStr(source2, DEFAULT_CHARSET);
    }

    public static String decodeStr(CharSequence source2, Charset charset) {
        return StrUtil.str(Base62.decode(source2), charset);
    }

    public static File decodeToFile(CharSequence Base622, File destFile) {
        return FileUtil.writeBytes(Base62.decode(Base622), destFile);
    }

    public static void decodeToStream(CharSequence base62Str, OutputStream out, boolean isCloseOut) {
        IoUtil.write(out, isCloseOut, Base62.decode(base62Str));
    }

    public static byte[] decode(CharSequence base62Str) {
        return Base62.decode(StrUtil.bytes(base62Str, DEFAULT_CHARSET));
    }

    public static byte[] decode(byte[] base62bytes) {
        return codec.decode(base62bytes);
    }
}

