/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class JarClassLoader
extends URLClassLoader {
    public static JarClassLoader load(File dir) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(dir);
        loader.addURL(dir);
        return loader;
    }

    public static JarClassLoader loadJar(File jarFile) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(jarFile);
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) throws UtilException {
        try {
            Method method = ClassUtil.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List<File> jars = JarClassLoader.loopJar(jarFile);
                for (File jar : jars) {
                    ReflectUtil.invoke((Object)loader, method, jar.toURI().toURL());
                }
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls2) {
        super(urls2, ClassUtil.getClassLoader());
    }

    public JarClassLoader addJar(File jarFileOrDir) {
        if (JarClassLoader.isJarFile(jarFileOrDir)) {
            return this.addURL(jarFileOrDir);
        }
        List<File> jars = JarClassLoader.loopJar(jarFileOrDir);
        for (File jar : jars) {
            this.addURL(jar);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public JarClassLoader addURL(File dir) {
        super.addURL(URLUtil.getURL(dir));
        return this;
    }

    private static List<File> loopJar(File file) {
        return FileUtil.loopFiles(file, JarClassLoader::isJarFile);
    }

    private static boolean isJarFile(File file) {
        if (!FileUtil.isFile(file)) {
            return false;
        }
        return file.getPath().toLowerCase().endsWith(".jar");
    }
}

