/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.HashMap;

public final class Singleton {
    private static final SimpleCache<String, Object> POOL = new SimpleCache(new HashMap());

    private Singleton() {
    }

    public static <T> T get(Class<T> clazz, Object ... params) {
        Assert.notNull(clazz, "Class must be not null !", new Object[0]);
        String key = Singleton.buildKey(clazz.getName(), params);
        return (T)POOL.get(key, () -> ReflectUtil.newInstance(clazz, params));
    }

    public static <T> T get(String className, Object ... params) {
        Assert.notBlank(className, "Class name must be not blank !", new Object[0]);
        Class clazz = ClassUtil.loadClass(className);
        return Singleton.get(clazz, params);
    }

    public static void put(Object obj) {
        Assert.notNull(obj, "Bean object must be not null !", new Object[0]);
        POOL.put(obj.getClass().getName(), obj);
    }

    public static void remove(Class<?> clazz) {
        if (null != clazz) {
            POOL.remove(clazz.getName());
        }
    }

    public static void destroy() {
        POOL.clear();
    }

    private static String buildKey(String className, Object ... params) {
        if (ArrayUtil.isEmpty(params)) {
            return className;
        }
        return StrUtil.format((CharSequence)"{}#{}", className, ArrayUtil.join(params, (CharSequence)"_"));
    }
}

