/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.multipart;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.multi.ListValueMap;
import cn.hutool.core.net.multipart.MultipartRequestInputStream;
import cn.hutool.core.net.multipart.UploadFile;
import cn.hutool.core.net.multipart.UploadFileHeader;
import cn.hutool.core.net.multipart.UploadSetting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultipartFormData {
    private final ListValueMap<String, String> requestParameters = new ListValueMap();
    private final ListValueMap<String, UploadFile> requestFiles = new ListValueMap();
    private final UploadSetting setting;
    private boolean loaded;

    public MultipartFormData() {
        this(null);
    }

    public MultipartFormData(UploadSetting uploadSetting) {
        this.setting = uploadSetting == null ? new UploadSetting() : uploadSetting;
    }

    public void parseRequestStream(InputStream inputStream2, Charset charset) throws IOException {
        UploadFileHeader header;
        this.setLoaded();
        MultipartRequestInputStream input = new MultipartRequestInputStream(inputStream2);
        input.readBoundary();
        while ((header = input.readDataHeader(charset)) != null) {
            if (header.isFile) {
                String fileName = header.fileName;
                if (fileName.length() > 0 && header.contentType.contains("application/x-macbinary")) {
                    input.skipBytes(128);
                }
                UploadFile newFile = new UploadFile(header, this.setting);
                newFile.processStream(input);
                this.putFile(header.formFieldName, newFile);
            } else {
                ByteArrayOutputStream fbos = new ByteArrayOutputStream(1024);
                input.copy(fbos);
                String value = charset != null ? new String(fbos.toByteArray(), charset) : new String(fbos.toByteArray());
                this.putParameter(header.formFieldName, value);
            }
            input.skipBytes(1);
            input.mark(1);
            int nextByte = input.read();
            if (nextByte == -1 || nextByte == 45) {
                input.reset();
                break;
            }
            input.reset();
        }
    }

    public String getParam(String paramName) {
        List<String> values2 = this.getListParam(paramName);
        if (CollUtil.isNotEmpty(values2)) {
            return values2.get(0);
        }
        return null;
    }

    public Set<String> getParamNames() {
        return this.requestParameters.keySet();
    }

    public String[] getArrayParam(String paramName) {
        List<String> listParam = this.getListParam(paramName);
        if (null != listParam) {
            return listParam.toArray(new String[0]);
        }
        return null;
    }

    public List<String> getListParam(String paramName) {
        return this.requestParameters.get(paramName);
    }

    public Map<String, String[]> getParamMap() {
        return Convert.toMap(String.class, String[].class, this.getParamListMap());
    }

    public ListValueMap<String, String> getParamListMap() {
        return this.requestParameters;
    }

    public UploadFile getFile(String paramName) {
        UploadFile[] values2 = this.getFiles(paramName);
        if (values2 != null && values2.length > 0) {
            return values2[0];
        }
        return null;
    }

    public UploadFile[] getFiles(String paramName) {
        List<UploadFile> fileList = this.getFileList(paramName);
        if (null != fileList) {
            return fileList.toArray(new UploadFile[0]);
        }
        return null;
    }

    public List<UploadFile> getFileList(String paramName) {
        return this.requestFiles.get(paramName);
    }

    public Set<String> getFileParamNames() {
        return this.requestFiles.keySet();
    }

    public Map<String, UploadFile[]> getFileMap() {
        return Convert.toMap(String.class, UploadFile[].class, this.getFileListValueMap());
    }

    public ListValueMap<String, UploadFile> getFileListValueMap() {
        return this.requestFiles;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void putFile(String name, UploadFile uploadFile) {
        this.requestFiles.putValue(name, uploadFile);
    }

    private void putParameter(String name, String value) {
        this.requestParameters.putValue(name, value);
    }

    private void setLoaded() throws IOException {
        if (this.loaded) {
            throw new IOException("Multi-part request already parsed.");
        }
        this.loaded = true;
    }
}

