/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.annotation.Alias;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectUtil {
    private static final SimpleCache<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Field[]> FIELDS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Method[]> METHODS_CACHE = new SimpleCache();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ReflectUtil.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            ReflectUtil.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        Constructor<?>[] constructors = CONSTRUCTORS_CACHE.get(beanClass);
        if (null != constructors) {
            return constructors;
        }
        constructors = ReflectUtil.getConstructorsDirectly(beanClass);
        return CONSTRUCTORS_CACHE.put(beanClass, constructors);
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return beanClass.getDeclaredConstructors();
    }

    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        return null != ReflectUtil.getField(beanClass, name);
    }

    public static String getFieldName(Field field) {
        if (null == field) {
            return null;
        }
        Alias alias = field.getAnnotation(Alias.class);
        if (null != alias) {
            return alias.value();
        }
        return field.getName();
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectUtil.getFields(beanClass);
        if (ArrayUtil.isNotEmpty(fields)) {
            for (Field field : fields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Map<String, Field> getFieldMap(Class<?> beanClass) {
        Field[] fields = ReflectUtil.getFields(beanClass);
        HashMap<String, Field> map = MapUtil.newHashMap(fields.length);
        for (Field field : fields) {
            map.put(field.getName(), field);
        }
        return map;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Field[] allFields = FIELDS_CACHE.get(beanClass);
        if (null != allFields) {
            return allFields;
        }
        allFields = ReflectUtil.getFieldsDirectly(beanClass, true);
        return FIELDS_CACHE.put(beanClass, allFields);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFieds) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayUtil.append(allFields, declaredFields);
            searchType = withSuperClassFieds ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static Object getFieldValue(Object obj, String fieldName) throws UtilException {
        if (null == obj || StrUtil.isBlank(fieldName)) {
            return null;
        }
        return ReflectUtil.getFieldValue(obj, ReflectUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName));
    }

    public static Object getStaticFieldValue(Field field) throws UtilException {
        return ReflectUtil.getFieldValue(null, field);
    }

    public static Object getFieldValue(Object obj, Field field) throws UtilException {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectUtil.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e, "IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return result;
    }

    public static Object[] getFieldsValue(Object obj) {
        Field[] fields;
        if (null != obj && null != (fields = ReflectUtil.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass()))) {
            Object[] values2 = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                values2[i] = ReflectUtil.getFieldValue(obj, fields[i]);
            }
            return values2;
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws UtilException {
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        Field field = ReflectUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        ReflectUtil.setFieldValue(obj, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws UtilException {
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ClassUtil.getDefaultValue(fieldType);
        }
        ReflectUtil.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e, "IllegalAccess for {}.{}", obj, field.getName());
        }
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        HashSet<String> methodSet = new HashSet<String>();
        Method[] methodArray = ReflectUtil.getPublicMethods(clazz);
        if (ArrayUtil.isNotEmpty(methodArray)) {
            for (Method method : methodArray) {
                methodSet.add(method.getName());
            }
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = ReflectUtil.getPublicMethods(clazz);
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollUtil.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        HashSet<Method> excludeMethodSet = CollUtil.newHashSet(excludeMethods);
        return ReflectUtil.getPublicMethods(clazz, (Method method) -> false == excludeMethodSet.contains(method));
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        HashSet<String> excludeMethodNameSet = CollUtil.newHashSet(excludeMethodNames);
        return ReflectUtil.getPublicMethods(clazz, (Method method) -> false == excludeMethodNameSet.contains(method.getName()));
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args2) throws SecurityException {
        if (null == obj || StrUtil.isBlank(methodName)) {
            return null;
        }
        return ReflectUtil.getMethod(obj.getClass(), methodName, ClassUtil.getClasses(args2));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || !ClassUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase)) continue;
                return method;
            }
        }
        return null;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectUtil.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return ArrayUtil.filter(ReflectUtil.getMethods(clazz), filter);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Method[] allMethods = METHODS_CACHE.get(beanClass);
        if (null != allMethods) {
            return allMethods;
        }
        allMethods = ReflectUtil.getMethodsDirectly(beanClass, true);
        return METHODS_CACHE.put(beanClass, allMethods);
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSuperClassMethods) throws SecurityException {
        Assert.notNull(beanClass);
        Method[] allMethods = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Method[] declaredMethods = searchType.getDeclaredMethods();
            allMethods = null == allMethods ? declaredMethods : ArrayUtil.append(allMethods, declaredMethods);
            searchType = withSuperClassMethods ? searchType.getSuperclass() : null;
        }
        return allMethods;
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !"equals".equals(method.getName())) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return 1 == paramTypes.length && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && ReflectUtil.isEmptyParam(method);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && ReflectUtil.isEmptyParam(method);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterTypes().length == 0;
    }

    public static <T> T newInstance(String clazz) throws UtilException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new UtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws UtilException {
        if (ArrayUtil.isEmpty(params)) {
            Constructor<T> constructor = ReflectUtil.getConstructor(clazz, new Class[0]);
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new UtilException(e, "Instance class [{}] error!", clazz);
            }
        }
        Class<?>[] paramTypes = ClassUtil.getClasses(params);
        Constructor<T> constructor = ReflectUtil.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new UtilException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new UtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> beanClass) {
        Assert.notNull(beanClass);
        try {
            return ReflectUtil.newInstance(beanClass, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<T>[] constructors;
            for (Constructor<T> constructor : constructors = ReflectUtil.getConstructors(beanClass)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectUtil.setAccessible(constructor);
                try {
                    return constructor.newInstance(ClassUtil.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args2) throws UtilException {
        return ReflectUtil.invoke(null, method, args2);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args2) throws UtilException {
        Class<?>[] types = method.getParameterTypes();
        if (null != args2) {
            Assert.isTrue(args2.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args2.length, types.length);
            for (int i = 0; i < args2.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args2[i]) continue;
                args2[i] = ClassUtil.getDefaultValue(type);
            }
        }
        return ReflectUtil.invoke(obj, method, args2);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args2) throws UtilException {
        ReflectUtil.setAccessible(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args2) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args2.length || null == args2[i]) {
                    actualArgs[i] = ClassUtil.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args2[i].getClass())) {
                    Object targetValue = Convert.convert(parameterTypes[i], args2[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args2[i];
            }
        }
        try {
            return (T)method.invoke(ClassUtil.isStatic(method) ? null : obj, actualArgs);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args2) throws UtilException {
        Method method = ReflectUtil.getMethodOfObj(obj, methodName, args2);
        if (null == method) {
            throw new UtilException(StrUtil.format((CharSequence)"No such method: [{}]", methodName));
        }
        return ReflectUtil.invoke(obj, method, args2);
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }
}

