/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.nosql.mongo;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.db.nosql.mongo.MongoDS;
import cn.hutool.setting.Setting;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MongoFactory {
    private static final String GROUP_SEPRATER = ",";
    private static final Map<String, MongoDS> DS_MAP = new ConcurrentHashMap<String, MongoDS>();

    public static MongoDS getDS(String host, int port) {
        String key = host + ":" + port;
        MongoDS ds = DS_MAP.get(key);
        if (null == ds) {
            ds = new MongoDS(host, port);
            DS_MAP.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(String ... groups2) {
        String key = ArrayUtil.join(groups2, (CharSequence)GROUP_SEPRATER);
        MongoDS ds = DS_MAP.get(key);
        if (null == ds) {
            ds = new MongoDS(groups2);
            DS_MAP.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Collection<String> groups2) {
        return MongoFactory.getDS(groups2.toArray(new String[0]));
    }

    public static MongoDS getDS(Setting setting, String ... groups2) {
        String key = setting.getSettingPath() + GROUP_SEPRATER + ArrayUtil.join(groups2, (CharSequence)GROUP_SEPRATER);
        MongoDS ds = DS_MAP.get(key);
        if (null == ds) {
            ds = new MongoDS(setting, groups2);
            DS_MAP.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Setting setting, Collection<String> groups2) {
        return MongoFactory.getDS(setting, groups2.toArray(new String[0]));
    }

    public static void closeAll() {
        if (CollectionUtil.isNotEmpty(DS_MAP)) {
            for (MongoDS ds : DS_MAP.values()) {
                ds.close();
            }
            DS_MAP.clear();
        }
    }

    static {
        RuntimeUtil.addShutdownHook(MongoFactory::closeAll);
    }
}

