package com.mugui.base.client.net.base;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Filter {
	public String[] value() default "*";

	public int type() default POSITIVE;
	
	public int weight() default 1;
	
	/**
	 * 	正向过滤，value匹配的将进入过滤器
	 */
	public int POSITIVE = 0;
	/**
	 * 	反向过滤，value不匹配的将进入过滤器
	 */
	public int REVERSE = 1;
	
	
}
