/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.base.client.net.bagsend;

import com.alibaba.fastjson.JSONObject;
import com.mugui.base.util.RequestMethod;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HTTPUtil {
    private static HashMap<String, OkHttpClient> map = new HashMap();

    public static Object get(String url) {
        return HTTPUtil.okHttp(RequestMethod.GET, url, null, null);
    }

    public static Object get(String url, Map<String, String> headler) {
        return HTTPUtil.okHttp(RequestMethod.GET, url, headler, null);
    }

    public static String post(String url) {
        return HTTPUtil.okHttp(RequestMethod.POST, url, null, null);
    }

    public static String post(String url, String body) {
        return HTTPUtil.okHttp(RequestMethod.POST, url, null, body);
    }

    public static String post(String url, Map<String, String> headler, String body) {
        return HTTPUtil.okHttp(RequestMethod.POST, url, headler, body);
    }

    public static String post(String url, Map<String, String> headler, JSONObject object, File[] file) {
        return HTTPUtil.okHttpFile(url, headler, object, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String okHttp(RequestMethod method, String url, Map<String, String> headler, String body) {
        OkHttpClient httpClient = map.get(url);
        if (httpClient == null) {
            HashMap<String, OkHttpClient> hashMap = map;
            synchronized (hashMap) {
                httpClient = map.get(url);
                if (httpClient == null) {
                    httpClient = new OkHttpClient().newBuilder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).build();
                    map.put(url, httpClient);
                }
            }
        }
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        Response response = null;
        try {
            Request.Builder request = HTTPUtil.getRequest(url, headler);
            if (method == RequestMethod.GET) {
                response = httpClient.newCall(request.get().build()).execute();
            } else if (method == RequestMethod.POST) {
                response = httpClient.newCall(request.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)body)).build()).execute();
            }
            if (response.code() == 200) {
                inputStream = response.body().byteStream();
                outputStream = new ByteArrayOutputStream();
                byte[] by = new byte[1024];
                int len = -1;
                while ((len = inputStream.read(by)) > -1) {
                    outputStream.write(by, 0, len);
                }
                String string = outputStream.toString("UTF-8");
                return string;
            }
            try {
                inputStream = response.body().byteStream();
                outputStream = new ByteArrayOutputStream();
                byte[] by = new byte[1024];
                int len = -1;
                while ((len = inputStream.read(by)) > -1) {
                    outputStream.write(by, 0, len);
                }
                throw new RuntimeException(response.code() + "" + outputStream.toString("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException((Object)((Object)method) + ":" + url + "--" + body, e);
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String okHttpFile(String url, Map<String, String> headler, JSONObject object, File[] file) {
        if (file == null || file.length == 0) {
            throw new RuntimeException("File file \u4e0d\u80fd\u4e3a\u7a7a");
        }
        OkHttpClient httpClient = map.get(url);
        if (httpClient == null) {
            HashMap<String, OkHttpClient> hashMap = map;
            synchronized (hashMap) {
                httpClient = map.get(url);
                if (httpClient == null) {
                    httpClient = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
                    map.put(url, httpClient);
                }
            }
        }
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        Response response = null;
        try {
            Request.Builder request = HTTPUtil.getRequest(url, headler);
            MultipartBody.Builder builder = new MultipartBody.Builder();
            builder.setType(MultipartBody.FORM);
            for (Map.Entry next : object.entrySet()) {
                if (next.getValue() == null) continue;
                builder.addFormDataPart((String)next.getKey(), next.getValue().toString());
            }
            for (int i = 0; i < file.length; ++i) {
            }
            response = httpClient.newCall(request.post((RequestBody)builder.build()).build()).execute();
            if (response.code() == 200) {
                inputStream = response.body().byteStream();
                outputStream = new ByteArrayOutputStream();
                byte[] by = new byte[1024];
                int len = -1;
                while ((len = inputStream.read(by)) > -1) {
                    outputStream.write(by, 0, len);
                }
                String string = outputStream.toString("UTF-8");
                return string;
            }
            try {
                inputStream = response.body().byteStream();
                outputStream = new ByteArrayOutputStream();
                byte[] by = new byte[1024];
                int len = -1;
                while ((len = inputStream.read(by)) > -1) {
                    outputStream.write(by, 0, len);
                }
                throw new RuntimeException(response.code() + "" + outputStream.toString("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException("okHttpFile :" + url + "--", e);
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static Request.Builder getRequest(String url, Map<String, String> headler) {
        Request.Builder builder = new Request.Builder().url(url);
        if (headler != null) {
            for (Map.Entry<String, String> next : headler.entrySet()) {
                builder = builder.addHeader(next.getKey().trim(), next.getValue().trim());
            }
        }
        return builder;
    }
}

