/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.base.client.net.bagsend;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.RandomUtil;
import com.mugui.base.base.Autowired;
import com.mugui.base.base.Component;
import com.mugui.base.client.net.baghandle.NetHandle;
import com.mugui.base.client.net.bagsend.BagSendTask;
import com.mugui.base.client.net.bagsend.HTTPUtil;
import com.mugui.base.client.net.bagsend.NetCall;
import com.mugui.base.client.net.bagsend.WSUtil;
import com.mugui.base.client.net.bagsend.WsHandle;
import com.mugui.base.client.net.bean.Message;
import com.mugui.base.client.net.bean.NetBag;
import com.mugui.base.util.Other;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

@Component
public class BagSend {
    private String server;
    @Autowired
    private NetHandle netHandle;
    private String session;
    private HashMap<String, String> sessionhead = new HashMap();
    private String http_server;
    private String ws_server;
    @Autowired
    private BagSendTask bagSendTask;
    @Autowired
    private WsHandle wsHandle;

    private String setSession(String session) {
        this.session = session;
        return this.session;
    }

    private String getSession() {
        return this.session;
    }

    public void init() {
        this.http_server = "http://" + this.server + "/";
        this.ws_server = "ws://" + this.server + "/";
    }

    public void setServerUrl(String url) {
        this.server = url;
        this.init();
    }

    public NetCall sendBag(final NetBag bag, final File ... file) {
        final NetCall netCall = new NetCall();
        this.bagSendTask.add(new Runnable(){

            @Override
            public void run() {
                bag.setHash(Other.MD5(bag.toString() + System.currentTimeMillis() + RandomUtil.randomInt()));
                bag.setSession(BagSend.this.getSession());
                String post = null;
                try {
                    post = file.length > 0 ? HTTPUtil.post(BagSend.this.http_server, BagSend.this.sessionhead, bag.toJson(), file) : HTTPUtil.post(BagSend.this.http_server, BagSend.this.sessionhead, bag.toString());
                    if (post == null) {
                        throw new RuntimeException(BagSend.this.http_server + " bag:" + (Object)((Object)bag) + "\u8bbf\u95ee\u9519\u8bef");
                    }
                }
                catch (Exception e) {
                    Message message = new Message();
                    message.setDate(e.getMessage());
                    message.setMsg("\u670d\u52a1\u5668\u51fa\u9519\u4e86");
                    message.setType(500);
                    bag.setData((Object)message);
                    post = bag.toString();
                }
                NetBag bag2 = (NetBag)((Object)NetBag.newBean(NetBag.class, (Object)post));
                if (StringUtils.isNotBlank((CharSequence)bag2.getSession())) {
                    BagSend.this.sessionhead.put("Cookie", "SESSION=" + BagSend.this.setSession(Base64.encode((CharSequence)bag2.getSession())) + "");
                }
                System.out.println("\u5904\u7406\u7ed3\u679c: " + BagSend.this.netHandle.httpHandle(bag2, netCall));
            }
        });
        return netCall;
    }

    public NetCall sendData(String func) {
        return this.sendData(func, null);
    }

    public NetCall sendData(String func, Object data) {
        NetBag bag = new NetBag();
        bag.setFunc(func).setData(data);
        return this.sendBag(bag, new File[0]);
    }

    public NetCall sendData(String func, Object data, File file) {
        NetBag bag = new NetBag();
        bag.setFunc(func).setData(data);
        return this.sendBag(bag, file);
    }

    public NetCall subWs(String func, Object data) {
        NetCall netCall = WSUtil.subNetCall(func);
        this.ws("sub." + func, null);
        return netCall;
    }

    public NetCall subWs(String func) {
        return this.subWs(func, null);
    }

    public void unsubWs(String func) {
        WSUtil.unsubNetCall(func);
        this.ws("unsub." + func, null);
    }

    private void ws(final String type_func, final Object data) {
        this.bagSendTask.add(new Runnable(){

            @Override
            public void run() {
                NetBag bag = new NetBag();
                bag.setFunc(type_func);
                bag.setData(data);
                bag.setHash(Other.MD5(bag.toString()));
                bag.setSession(Base64.decodeStr((CharSequence)BagSend.this.getSession()));
                WSUtil.ws(BagSend.this.ws_server, BagSend.this.sessionhead, bag.toString(), BagSend.this.wsHandle);
            }
        });
    }
}

