package com.mugui.base.client.net.bagsend;


import java.util.HashMap;


public class WSUtil {

	public static void ws(String serverUrl, HashMap<String, String> sessionhead, String string, WsHandle wsHandle) {
		if (wsHandle.getClient() == null) {
			synchronized (WSUtil.class) {
				if (wsHandle.getClient() == null) {
					wsHandle.init(serverUrl);
					sessionhead.forEach((k, v) -> {
						wsHandle.getClient().addHeader(k, v);
					});
				}
			}
		}
		wsHandle.getClient().send(string);
	}
	private static HashMap<String, NetCall> wsNetCalls = new HashMap<>();

	public static NetCall getWsNetCall(String func){
		return wsNetCalls.get(func);
	}
	public static NetCall subNetCall(String func){
		NetCall netCall=null;
		synchronized (wsNetCalls) {
			netCall = wsNetCalls.get(func);
			if (netCall == null) {
				netCall = new NetCall();
				wsNetCalls.put(func, netCall);
			}
		}
		return wsNetCalls.get(func);
	}

	public static void unsubNetCall(String func) {
		synchronized (wsNetCalls) {
			wsNetCalls.remove(func);
		}
	}
}
