package com.mugui.base.client.net.baghandle;



import com.mugui.Mugui;
import com.mugui.base.base.ApplicationContext;
import com.mugui.base.base.Component;
import com.mugui.base.client.net.auto.AutoLoadManager;
import com.mugui.base.client.net.auto.AutoTask;
import com.mugui.base.client.net.base.ModelInterface;
import com.mugui.base.client.net.base.ModelManagerInterface;
import com.mugui.base.client.net.base.Module;
import com.mugui.base.client.net.base.TaskInterface;
import com.mugui.base.client.net.cache.CacheMessage;
import com.mugui.base.client.net.classutil.DataSave;
import com.mugui.base.client.net.filter.FilterManager;
import com.mugui.base.client.net.listener.ListenerManager;
import com.mugui.base.client.net.task.TaskManager;

import java.util.HashMap;

import lombok.Getter;


@Component
public class NetBagModuleManager implements ModelManagerInterface {

	private static HashMap<String, ModelInterface> map = null;
	@Getter
	private FilterManager filterMessage = null;
	@Getter
	private ListenerManager listenerMessage = null;
	@Getter
	private CacheMessage cacheMessage = null;

	public void init() {
		clear();
		map = new HashMap<>();

	}

	public <T> T getModelManager(Class<T> class1) {
		return applicationContext.getBean(class1);
	}

	private ApplicationContext applicationContext = null;

	@Override
	public boolean init(Object o) {
		Class<?> name = (Class<?>) o;
		init();
		TaskManager manager = TaskManager.getTaskManager();
		manager.init();
		applicationContext = (ApplicationContext) DataSave.context;
		filterMessage = applicationContext.getBean(FilterManager.class);
		filterMessage.init(name);
		listenerMessage = applicationContext.getBean(ListenerManager.class);
		listenerMessage.init(name);
		cacheMessage = applicationContext.getBean(CacheMessage.class);
		cacheMessage.init(name);
		applicationContext.getBean(AutoLoadManager.class).init(name);
		for (Class<?> class_name : DataSave.initClassList(name)) {
			if (class_name.isAnnotationPresent(Module.class)) {
				try {
					System.out.println("module加载：" + class_name.getName());
					handleModule(class_name);
				} catch (Exception e) {
					e.printStackTrace();
					throw new RuntimeException(e);
				}
			}
			if (class_name.isAnnotationPresent(AutoTask.class)) {
				TaskInterface interface1 = (TaskInterface) applicationContext.getBean(class_name);
				try {
					interface1.invokeFunction("init");
				} catch (Exception e) {
					e.printStackTrace();
				}
				manager.add(interface1);
			}
		}
		System.getProperties().put("system_lock", false);
		return true;
	}

	/**
	 * 处理模块
	 * 
	 * @param class_name
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws Exception
	 */

	private void handleModule(Class<?> class_name) throws InstantiationException, IllegalAccessException, Exception {

		if (!Mugui.class.isAssignableFrom(class_name)) {
			throw new RuntimeException("Module  not implements Mugui of " + class_name.getName());
		}
		Module module = class_name.getAnnotation(Module.class);
		ModelInterface modelInterface = null;
		modelInterface = map.get(module.name() + "." + module.type());
		if (modelInterface != null) {
			// throw new RuntimeException("module :" + module.name() + "." + module.type() +
			// " is already defined of "
			// + class_name.getName());
			return;
		}
		if ((modelInterface = map.get(module.name() + "." + module.type())) == null) {
			modelInterface = new NetBagModule();
		}
		modelInterface.invokeFunction("init", class_name.newInstance());
		map.put(module.name() + "." + module.type(), modelInterface);

	}

	@Override
	public boolean clear() {
		if (map != null)
			map.clear();
		return true;
	}

	@Override
	public boolean is(String name) {
		if (map == null) {
			throw new NullPointerException("please run init");
		}
		return !map.isEmpty() && map.get(name) != null;
	}

	@Override
	public ModelInterface del(String name) {
		if (map == null) {
			throw new NullPointerException("please run init");
		}
		return map.remove(name);
	}

	@Override
	public ModelInterface get(String name) {
		if (map == null) {
			throw new NullPointerException("please run init");
		}
		return map.get(name);
	}

	@Override
	public boolean add(String name, ModelInterface object) {
		if (map == null) {
			throw new NullPointerException("please run init");
		}
		return true;
	}

	@Override
	public boolean isInit() {
		// TODO Auto-generated method stub
		return false;
	}

}
