package com.mugui.base.client.net.filter;



import com.mugui.base.base.ApplicationContext;
import com.mugui.base.base.Component;
import com.mugui.base.client.net.base.Filter;
import com.mugui.base.client.net.base.ManagerInterface;
import com.mugui.base.client.net.classutil.DataSave;

import java.util.HashMap;
import java.util.Map.Entry;
import java.util.Set;


@Component
public class FilterManager implements ManagerInterface<String, FilterModel> {
    private static HashMap<String, FilterModel> map = null;

    public void init() {
        clear();
        map = new HashMap<>();
    }

    public Set<Entry<String, FilterModel>> entrySet() {
        return map.entrySet();
    }

    private ApplicationContext applicationContext = null;

    @Override
    public boolean init(Object object) {
        Class<?> name = (Class<?>) object;
        init();
        applicationContext = (ApplicationContext) DataSave.context;
        for (Class<?> class_name : DataSave.initClassList(name)) {
            if (class_name.isAnnotationPresent(Filter.class)) {
                System.out.println("过滤器：" + class_name.getName());
                Filter filter = class_name.getAnnotation(Filter.class);
                map.put(filter.hashCode() + "", (FilterModel) applicationContext.getBean(class_name));
            }
        }
        return false;
    }

    @Override
    public boolean clear() {
        if (map != null)
            map.clear();
        return true;
    }

    @Override
    public boolean is(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return !map.isEmpty() && map.get(name) != null;
    }

    @Override
    public FilterModel del(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return map.remove(name);
    }

    @Override
    public FilterModel get(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return map.get(name);
    }

    @Override
    public boolean add(String name, FilterModel object) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return true;
    }

    @Override
    public boolean isInit() {
        // TODO Auto-generated method stub
        return false;
    }

}
