/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.base.client.net.bagsend;

import cn.hutool.core.util.URLUtil;
import com.mugui.base.base.Autowired;
import com.mugui.base.base.Component;
import com.mugui.base.client.net.baghandle.NetHandle;
import com.mugui.base.client.net.bean.NetBag;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

@Component
public class WsHandle {
    @Autowired
    private NetHandle handle;
    WebSocketClient client = null;

    public void init(String serverUrl) {
        if (this.client == null) {
            this.client = new WebSocketClient(URLUtil.toURI((String)serverUrl)){

                public void onOpen(ServerHandshake serverHandshake) {
                    WsHandle.this.onOpen(serverHandshake);
                }

                public void onMessage(String s) {
                    WsHandle.this.onMessage(s);
                }

                public void onMessage(ByteBuffer bytes) {
                    WsHandle.this.onMessage(Charset.defaultCharset().decode(bytes).toString());
                }

                public void onClose(int i, String s, boolean b) {
                    WsHandle.this.onClose(i, s, b);
                }

                public void onError(Exception e) {
                    WsHandle.this.onError(e);
                }
            };
        }
    }

    public void onOpen(ServerHandshake serverHandshake) {
        System.out.println("WebSocketListener->>onOpen");
    }

    public void onMessage(String text) {
        this.handle.WsHandle((NetBag)((Object)NetBag.newBean(NetBag.class, (Object)text)));
    }

    public void onClose(int i, String s, boolean b) {
        this.close();
    }

    private void close() {
        if (this.client != null && this.client.getSocket() != null) {
            try {
                this.client.getSocket().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.client = null;
        System.out.println("WebSocketListener->>onClose");
    }

    public void onError(Exception e) {
        System.out.println("WebSocketListener->>onFailure ");
        e.printStackTrace();
        this.close();
    }

    public WebSocketClient getClient() {
        return this.client;
    }
}

