/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.base.client.net.task;

import com.mugui.Mugui;
import com.mugui.base.base.ApplicationContext;
import com.mugui.base.base.Autowired;
import com.mugui.base.base.Component;
import com.mugui.base.client.net.base.Task;
import com.mugui.base.client.net.base.TaskInterface;
import com.mugui.base.client.net.classutil.DataSave;
import com.mugui.base.util.Other;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TaskManager
implements Mugui {
    private static TaskManager taskManager = null;
    private boolean isrun = true;
    private static TaskRunThread outTimeThread = null;
    private static final HashMap<Class<? extends TaskInterface>, TaskThread> TaskMap = new HashMap();
    private static HashMap<Class<? extends TaskInterface>, Field[]> hashMap = new HashMap();
    private ApplicationContext applicationContext = null;

    public static final TaskManager getTaskManager() {
        if (taskManager == null) {
            taskManager = new TaskManager();
        }
        return taskManager;
    }

    public void stop() {
        this.isrun = false;
    }

    public void init() {
        if (outTimeThread == null || !outTimeThread.isAlive()) {
            this.isrun = true;
            outTimeThread = new TaskRunThread();
            outTimeThread.setName("outTimeThread");
            outTimeThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TaskInterface object) {
        if (this.applicationContext == null) {
            this.applicationContext = DataSave.context;
        }
        if (object.getClass().isAnnotationPresent(Task.class)) {
            Task task = object.getClass().getAnnotation(Task.class);
            Field[] fields = new Field[]{};
            try {
                fields = hashMap.get(object.getClass());
                if (fields == null && object.getClass().isAnnotationPresent(Component.class)) {
                    Field[] temp = object.getClass().getDeclaredFields();
                    ArrayList<Field> list = new ArrayList<Field>();
                    for (Field field : temp) {
                        if (!field.isAnnotationPresent(Autowired.class)) continue;
                        list.add(field);
                    }
                    fields = list.toArray(new Field[0]);
                }
                if (fields != null) {
                    for (Field field : fields) {
                        field.setAccessible(true);
                        field.set(object, field.get(this.applicationContext.getBean(object.getClass())));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                hashMap.put(object.getClass(), fields);
            }
            TempBean bean = new TempBean();
            bean.task = task;
            bean.object = object;
            int task_time = task.time() == 0 ? 1000 : task.time();
            bean.out_time = System.currentTimeMillis() + (long)task_time;
            outTimeThread.addMapBodyBean(bean);
            return;
        }
        throw new NullPointerException("\u672a\u6dfb\u52a0\u6ce8\u89e3@Task");
    }

    @Deprecated
    public void remove(TaskInterface object) {
        if (object.getClass().isAnnotationPresent(Task.class)) {
            Task task = object.getClass().getAnnotation(Task.class);
            TempBean bean = new TempBean();
            bean.task = task;
            bean.object = object;
            outTimeThread.removeMapBodyBean(bean);
            return;
        }
        throw new NullPointerException("\u672a\u6dfb\u52a0\u6ce8\u89e3@Task");
    }

    private class TempThread
    extends Thread {
        private ConcurrentLinkedQueue<TaskInterface> list = new ConcurrentLinkedQueue();

        private TempThread() {
        }

        public void add(TaskInterface object) {
            this.list.add(object);
        }

        @Override
        public void run() {
            while (true) {
                TaskInterface taskInterface = null;
                try {
                    while ((taskInterface = this.list.poll()) == null) {
                        Other.sleep(500);
                    }
                    taskInterface.run();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public class TaskThread {
        private TempThread th = null;

        public TaskThread(TaskInterface object) {
            TaskThread thread = null;
            thread = (TaskThread)TaskMap.get(object.getClass());
            if (thread == null) {
                thread = this;
                TaskMap.put(object.getClass(), thread);
            }
            if (thread.th == null || !thread.th.isAlive()) {
                thread.th = new TempThread();
                thread.th.setName(object.getClass().getName());
                thread.th.start();
            }
            thread.th.add(object);
        }
    }

    private class TaskRunThread
    extends Thread {
        private TaskQueue outTimeQueue = new TaskQueue();

        private TaskRunThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (TaskManager.this.isrun) {
                try {
                    TempBean bean = null;
                    TaskQueue taskQueue = this.outTimeQueue;
                    synchronized (taskQueue) {
                        while (this.outTimeQueue.size() == 0) {
                            this.outTimeQueue.wait(15000L);
                        }
                        bean = this.outTimeQueue.poll();
                        if (bean == null) {
                            continue;
                        }
                        long wait_time = bean.out_time - System.currentTimeMillis();
                        if (wait_time > 0L) {
                            this.outTimeQueue.wait(wait_time);
                            continue;
                        }
                        bean = this.outTimeQueue.remove();
                    }
                    if (bean == null) continue;
                    try {
                        new TaskThread(bean.object);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (bean.task.value() != 1) continue;
                    int task_time = bean.task.blank() == 0 ? 1000 : bean.task.blank();
                    bean.out_time = System.currentTimeMillis() + (long)task_time;
                    this.addMapBodyBean(bean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMapBodyBean(TempBean mapBodyBean) {
            TaskQueue taskQueue = this.outTimeQueue;
            synchronized (taskQueue) {
                this.outTimeQueue.add(mapBodyBean);
                this.outTimeQueue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMapBodyBean(TempBean bean) {
            TaskQueue taskQueue = this.outTimeQueue;
            synchronized (taskQueue) {
                this.outTimeQueue.remove(bean);
                this.outTimeQueue.notifyAll();
            }
        }

        private class TaskQueue {
            TempBean[] queue = new TempBean[128];
            int size = 0;
            private final byte REMOVE = 1;
            private final byte FIXUP = (byte)2;
            private final byte FIXDOWN = (byte)3;

            private TaskQueue() {
            }

            int size() {
                return this.size;
            }

            TempBean remove() {
                return this.handle(1, (byte)1);
            }

            TempBean remove(int index) {
                return this.handle(index, (byte)1);
            }

            TempBean remove0(int index) {
                TempBean bean = this.queue[index];
                for (int i = index; i < this.size; ++i) {
                    this.queue[i] = this.queue[i + 1];
                }
                this.queue[this.size] = null;
                --this.size;
                return bean;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TempBean handle(int index, byte type) {
                TempBean[] tempBeanArray = this.queue;
                synchronized (this.queue) {
                    switch (type) {
                        case 1: {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return this.remove0(index);
                        }
                        case 2: {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return this.fixUp0(index);
                        }
                        case 3: {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return this.fixDown0(index);
                        }
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return null;
                }
            }

            void add(TempBean bean) {
                for (int i = 1; i < this.size; ++i) {
                    if (this.queue[i] == null || this.queue[i].object != bean.object) continue;
                    throw new RuntimeException("\u53cd\u590d\u8fd0\u884c\u7684\u76f8\u540c\u4efb\u52a1" + bean.object);
                }
                ++this.size;
                if (this.queue.length == this.size) {
                    this.queue = Arrays.copyOf(this.queue, 2 * this.size);
                }
                this.queue[this.size] = bean;
                this.fixUp(this.size);
            }

            private TempBean fixUp0(int index) {
                for (int i = index; i > 1; --i) {
                    if (this.queue[i] == null) {
                        this.remove0(i);
                        continue;
                    }
                    if (this.queue[i - 1] == null) {
                        throw new NullPointerException("i - 1=" + (i - 1) + " index=" + index);
                    }
                    if (this.queue[i].out_time >= this.queue[i - 1].out_time) break;
                    this.queue[0] = this.queue[i];
                    this.queue[i] = this.queue[i - 1];
                    this.queue[i - 1] = this.queue[0];
                }
                return null;
            }

            private void fixUp(int index) {
                this.handle(index, (byte)2);
            }

            public TempBean fixDown0(int index) {
                for (int i = index; i < this.size && this.queue[i].out_time > this.queue[i + 1].out_time; ++i) {
                    this.queue[0] = this.queue[i];
                    this.queue[i] = this.queue[i + 1];
                    this.queue[i + 1] = this.queue[0];
                }
                return null;
            }

            public void fixDown(int index) {
                this.handle(index, (byte)3);
            }

            public TempBean poll() {
                return this.queue[1];
            }

            public void remove(TempBean bean) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.queue[i] == null || this.queue[i].object != bean.object) continue;
                    this.remove(i);
                    return;
                }
            }
        }
    }

    private class TempBean {
        private long out_time;
        private TaskInterface object;
        private Task task;

        private TempBean() {
        }
    }
}

