package com.mugui.Dui;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DLabelTextField extends JPanel {
	/**
	 * 
	 */
	private static final long serialVersionUID = 6843960379211673080L;
	private JTextField textField = null;
	private int type = 0;

	public DLabelTextField(String label, int type) {
		this(label, type, 32);
	}

	public DLabelTextField(String label) {
		this(label, 0);
	}

	public DLabelTextField(String label, int type, int columns) {
		this(label, type, columns, new Font("宋体", Font.BOLD, 20), new Font("宋体", Font.BOLD, 15));
	}

	public DLabelTextField(String label, int type, int columns, Font label_font, Font textfield_font) {
		this.type = type;
		JLabel label_1 = new JLabel(label);
		DLabelTextField.this.add(label_1);
		label_1.setForeground(Color.RED);
		label_1.setFont(label_font);
		switch (type) {
		case 0:
			textField = new DTextField(columns);
			break;
		case 1:
			textField = new JPasswordField(columns);
			break;
		}
		DLabelTextField.this.add(textField);
		textField.setColumns(columns);
		textField.setFont(textfield_font);
	}

	public char[] getPassword() {
		return ((JPasswordField) textField).getPassword();
	}

	public void setEditable(boolean bool) {
		textField.setEditable(bool);
	}

	public boolean isEditable() {
		return textField.isEditable();
	}

	public String getText() {
		switch (type) {
		case 0:
			return textField.getText();
		case 1:
			return String.valueOf(getPassword());
		}
		throw new NullPointerException("textfield is null?");
	}

	public void setText(String text) {
		textField.setText(text);
	}
}
