/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.Dui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalButtonUI;

public class DButton
extends JButton {
    private static final long serialVersionUID = -6655761286238492290L;
    private static final String[] lstr = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private Color pressColor = DEFAULT_PRESS_COLOR;
    private static final Color DEFAULT_PRESS_COLOR = Color.DARK_GRAY;

    @Override
    public void setText(String text) {
        if (text != null && text.length() != 0) {
            Font font = this.getFont();
            if (font.canDisplayUpTo(text) == -1) {
                super.setText(text);
            } else {
                for (String str : lstr) {
                    Font f = new Font(str, font.getStyle(), font.getSize());
                    if (f.canDisplayUpTo(text) != -1) continue;
                    super.setText(text);
                    super.setFont(f);
                    return;
                }
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        String text = this.getText();
        if (text != null && text.length() != 0) {
            if (font.canDisplayUpTo(text) == -1) {
                super.setFont(font);
            } else {
                for (String str : lstr) {
                    Font f = new Font(str, font.getStyle(), font.getSize());
                    if (f.canDisplayUpTo(text) != -1) continue;
                    super.setFont(f);
                    return;
                }
            }
        }
    }

    public DButton(String text, Color color) {
        this.setUI(new DMetalButtonUI());
        this.setText(text);
        this.setFont(new Font("\u534e\u6587\u884c\u9b4f", 1, 17));
        this.setFocusPainted(false);
        this.setBackground(Color.DARK_GRAY);
        if (color == null) {
            color = Color.white;
        }
        this.setForeground(color);
        this.setBorder(new MetalBorders.ButtonBorder());
    }

    public void setButtonPressColor(Color color) {
        if (color == null) {
            this.pressColor = DEFAULT_PRESS_COLOR;
            return;
        }
        this.pressColor = color;
    }

    private class DMetalButtonUI
    extends MetalButtonUI
    implements Serializable {
        private static final long serialVersionUID = -508986144537417765L;

        private DMetalButtonUI() {
        }

        @Override
        protected void paintButtonPressed(Graphics g, AbstractButton b) {
            if (b.isContentAreaFilled()) {
                Dimension size = b.getSize();
                g.setColor(DButton.this.pressColor);
                g.fillRect(0, 0, size.width, size.height);
            }
        }
    }
}

