/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.Dui;

import com.mugui.Dui.DDocument;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class DTextField
extends JTextField {
    private static final long serialVersionUID = 9074513222366556397L;
    private String infoText = null;
    private boolean listener_bool = false;
    private KeyAdapter KeyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (DTextField.this.option == 88) {
                Field[] fields;
                for (Field f : fields = KeyEvent.class.getFields()) {
                    try {
                        if (!(f.get(null) instanceof Integer) || f.getInt(null) != e.getKeyCode() || !f.getName().startsWith("VK_")) continue;
                        ((DTextField)e.getSource()).setText(f.getName().substring(3, f.getName().length()));
                    }
                    catch (IllegalArgumentException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            if (DTextField.this.codeListener != null) {
                DTextField.this.codeListener.callBack((DTextField)e.getSource());
            }
            DTextField.this.document.setInsertBool(false);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            DTextField.this.document.setInsertBool(true);
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            ((DTextField)e.getSource()).setText(e.getButton() + "");
            if (DTextField.this.codeListener != null) {
                DTextField.this.codeListener.callBack((DTextField)e.getSource());
            }
            DTextField.this.document.setInsertBool(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DTextField.this.document.setInsertBool(true);
        }
    };
    private CodeListener codeListener = null;
    private DDocument document = null;
    public static final int OPTION_INT = 1;
    public static final int OPTION_KEY_LISTENER = 88;
    public static final int OPTION_MOUSE_LISTENER = 89;
    public int option = 0;
    private static final String[] lstr = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    public void setKeyCodeListener(boolean bool) {
        this.option = 88;
        this.setCodeListener(bool);
    }

    public void setCodeListener(boolean bool) {
        this.listener_bool = bool;
        if (this.listener_bool) {
            this.removeMouseListener(this.mouseListener);
            this.addKeyListener(this.KeyListener);
        } else {
            this.removeKeyListener(this.KeyListener);
        }
    }

    public void addCodeListener(CodeListener codeListener) {
        this.codeListener = codeListener;
        if (!this.listener_bool) {
            this.setCodeListener(true);
        }
    }

    public void addKeyCodeListener(CodeListener keyCodeListener) {
        this.option = 88;
        this.addCodeListener(keyCodeListener);
    }

    public void setMouseCodeListener(boolean bool) {
        this.option = 89;
        this.listener_bool = bool;
        if (this.listener_bool) {
            this.removeKeyListener(this.KeyListener);
            this.addMouseListener(this.mouseListener);
        } else {
            this.removeMouseListener(this.mouseListener);
        }
    }

    public void addMouseCodeListener(CodeListener keyCodeListener) {
        this.option = 89;
        this.codeListener = keyCodeListener;
        if (!this.listener_bool) {
            this.setMouseCodeListener(true);
        }
    }

    public DTextField(int len) {
        this(len, null);
    }

    public DTextField(String text) {
        this(32, text);
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (this.infoText == null) {
            return text;
        }
        if (this.infoText.equals(text)) {
            return "";
        }
        return text;
    }

    public void setOption(int option) {
        this.option = option;
        switch (option) {
            case 88: {
                this.setKeyCodeListener(true);
                break;
            }
            case 89: {
                this.setMouseCodeListener(true);
                break;
            }
            default: {
                this.document.setOption(option);
            }
        }
    }

    public DTextField(int len, String text) {
        this.document = new DDocument(len);
        this.setDocument(this.document);
        this.setText(text);
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                String text;
                Font font = DTextField.this.getFont();
                if (font.canDisplayUpTo(text = DTextField.this.getText()) != -1) {
                    for (String str : lstr) {
                        Font f = new Font(str, font.getStyle(), font.getSize());
                        if (f.canDisplayUpTo(text) != -1) continue;
                        DTextField.this.setFont(f);
                        return;
                    }
                }
            }
        });
    }

    @Override
    public void setText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        Font font = this.getFont();
        if (font.canDisplayUpTo(text) != -1) {
            for (String str : lstr) {
                Font f = new Font(str, font.getStyle(), font.getSize());
                if (f.canDisplayUpTo(text) != -1) continue;
                this.setFont(f);
                super.setText(text);
                return;
            }
        }
        super.setText(text);
    }

    public static interface CodeListener {
        public void callBack(DTextField var1);
    }
}

