/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.tool;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ImgTool {
    private static ImageWriter writer = null;
    private static JPEGImageWriteParam writeParam = null;

    public static void FitTableColumns(JTable myTable) {
        JTableHeader header = myTable.getTableHeader();
        int rowCount = myTable.getRowCount();
        Enumeration<TableColumn> columns = myTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int col = header.getColumnModel().getColumnIndex(column.getIdentifier());
            int width = (int)myTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(myTable, column.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            for (int row = 0; row < rowCount; ++row) {
                int preferedWidth = (int)myTable.getCellRenderer(row, col).getTableCellRendererComponent(myTable, myTable.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
            }
            header.setResizingColumn(column);
            column.setWidth(width + myTable.getIntercellSpacing().width + 5);
            FontMetrics label = myTable.getFontMetrics(myTable.getFont());
            myTable.setRowHeight(label.getHeight());
        }
    }

    public static BufferedImage cutImage(BufferedImage img, int x, int y, int w, int h) {
        try {
            return img.getSubimage(x, y, w, h);
        }
        catch (Exception e) {
            try {
                throw new Exception(img.getWidth() + " " + img.getHeight() + " " + x + " " + y + " " + w + " " + h);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static BufferedImage binaryzationImage2(BufferedImage image) {
        BufferedImage grayImage = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        int color = image.getRGB(0, 0);
        int color2 = new Color(255, 255, 255).getRGB();
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                if (color == image.getRGB(i, j)) {
                    grayImage.setRGB(i, j, color);
                    continue;
                }
                grayImage.setRGB(i, j, color2);
            }
        }
        return grayImage;
    }

    public static BufferedImage grayscaleImage(BufferedImage image) {
        BufferedImage grayImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                grayImage.setRGB(i, j, image.getRGB(i, j));
            }
        }
        return grayImage;
    }

    public static BufferedImage imageEnlarge(BufferedImage image, double i) {
        BufferedImage result = new BufferedImage((int)(i * (double)image.getWidth()), (int)(i * (double)image.getHeight()), 1);
        result.getGraphics().drawImage(image.getScaledInstance((int)(i * (double)image.getWidth()), (int)(i * (double)image.getHeight()), 4), 0, 0, null);
        return result;
    }

    public static BufferedImage imageStretching(BufferedImage image, int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 1);
        int w = image.getWidth();
        int h = image.getHeight();
        double fan = 1.0;
        fan = w > h ? (double)width / ((double)w * 1.0) : (double)height / ((double)h * 1.0);
        result.getGraphics().drawImage(image.getScaledInstance((int)((double)w * fan), (int)((double)h * fan), 4), -((int)((double)w * fan)) / 2 + width / 2, -((int)((double)h * fan)) / 2 + height / 2, null);
        return result;
    }

    public static BufferedImage clearAdhesion(BufferedImage image) {
        int j;
        int i;
        int width = image.getWidth();
        int height = image.getHeight();
        int color = image.getRGB(0, 0);
        BufferedImage temp = new BufferedImage(width, height, image.getType());
        temp.getGraphics().drawImage(image, 0, 0, null);
        image = temp;
        int state = 0;
        int state2 = 0;
        int pole = height - 1;
        int pole2 = 0;
        block0: for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                if (state == 0 && image.getRGB(i, j) != color) {
                    if (j <= pole) {
                        pole = j;
                        continue block0;
                    }
                    state = 1;
                    pole = j;
                    continue block0;
                }
                if (state == 1 && image.getRGB(i, j) != color) {
                    if (j < pole) {
                        state = 2;
                        --i;
                    } else {
                        pole = j;
                        continue block0;
                    }
                }
                if (state != 2 && j == height - 1) {
                    pole = j;
                    state = 0;
                    continue block0;
                }
                if (state != 2) continue;
                image.setRGB(i, j, color);
                if (j != height - 1) continue;
                pole = j;
                state = 0;
                ++i;
                continue block0;
            }
        }
        block2: for (i = 0; i < width; ++i) {
            for (j = height - 1; j >= 0; --j) {
                if (state2 == 0 && image.getRGB(i, j) != color) {
                    if (j >= pole2) {
                        pole2 = j;
                        continue block2;
                    }
                    state2 = 1;
                    pole2 = j;
                    continue block2;
                }
                if (state2 == 1 && image.getRGB(i, j) != color) {
                    if (j > pole2) {
                        state2 = 2;
                        --i;
                    } else {
                        pole2 = j;
                        continue block2;
                    }
                }
                if (state2 != 2 && j == 0) {
                    pole2 = j;
                    state2 = 0;
                    continue block2;
                }
                if (state2 != 2) continue;
                image.setRGB(i, j, color);
                if (j != 0) continue;
                pole2 = j;
                state2 = 0;
                ++i;
                continue block2;
            }
        }
        return image;
    }

    public static double[] imageToDoubleArrays(BufferedImage bimage) {
        int smallHeight = bimage.getHeight();
        int smallWidth = bimage.getWidth();
        int[] pixes = new int[smallWidth * smallHeight];
        double[] grayMatrix = new double[smallWidth * smallHeight];
        int index = -1;
        pixes = (int[])bimage.getRaster().getDataElements(0, 0, smallWidth, smallHeight, pixes);
        for (int i = 0; i < smallWidth; ++i) {
            for (int j = 0; j < smallHeight; ++j) {
                int rgb = pixes[i * smallWidth + j];
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                double gray = Double.valueOf(r * 299 + g * 587 + b * 114 + 500) / 255000.0;
                grayMatrix[++index] = gray;
            }
        }
        return grayMatrix;
    }

    public static BufferedImage binaryzationImage(BufferedImage src) {
        int means;
        int width = src.getWidth();
        int height = src.getHeight();
        BufferedImage dest = new BufferedImage(width, height, 1);
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        inPixels = src.getRGB(0, 0, width, height, null, 0, width);
        int index = 0;
        try {
            means = ImgTool.getThreshold(inPixels, height, width);
        }
        catch (Exception e) {
            return null;
        }
        for (int row = 0; row < height; ++row) {
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int col = 0; col < width; ++col) {
                index = row * width + col;
                ta = inPixels[index] >> 24 & 0xFF;
                tr = inPixels[index] >> 16 & 0xFF;
                tg = inPixels[index] >> 8 & 0xFF;
                tb = inPixels[index] & 0xFF;
                if (tr > means) {
                    tb = 255;
                    tg = 255;
                    tr = 255;
                } else {
                    tb = 0;
                    tg = 0;
                    tr = 0;
                }
                outPixels[index] = ta << 24 | tr << 16 | tg << 8 | tb;
            }
        }
        dest.setRGB(0, 0, width, height, outPixels, 0, width);
        return dest;
    }

    private static int getThreshold(int[] inPixels, int height, int width) throws Exception {
        int inithreshold = 127;
        int finalthreshold = 0;
        int[] temp = new int[inPixels.length];
        for (int index = 0; index < inPixels.length; ++index) {
            temp[index] = inPixels[index] >> 16 & 0xFF;
        }
        ArrayList<Integer> sub1 = new ArrayList<Integer>();
        ArrayList<Integer> sub2 = new ArrayList<Integer>();
        int means1 = 0;
        int means2 = 0;
        while (finalthreshold != inithreshold) {
            finalthreshold = inithreshold;
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i] <= inithreshold) {
                    sub1.add(temp[i]);
                    continue;
                }
                sub2.add(temp[i]);
            }
            means1 = ImgTool.getMeans(sub1);
            means2 = ImgTool.getMeans(sub2);
            sub1.clear();
            sub2.clear();
            inithreshold = (means1 + means2) / 2;
        }
        return finalthreshold;
    }

    private static int getMeans(List<Integer> data) throws Exception {
        int result = 0;
        int size = data.size();
        for (Integer i : data) {
            result += i.intValue();
        }
        if (size <= 0) {
            throw new Exception();
        }
        return result / size;
    }

    public static BufferedImage imageInverse(BufferedImage src) {
        int w = src.getWidth();
        int h = src.getHeight();
        BufferedImage temp = new BufferedImage(w, h, 1);
        temp.getGraphics().drawImage(src, 0, 0, null);
        int[] pixels = new int[w * h];
        pixels = temp.getRGB(0, 0, w, h, null, 0, w);
        for (int i = 0; i < pixels.length; ++i) {
            Color c = new Color(pixels[i]);
            c = new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
            pixels[i] = c.getRGB();
        }
        temp.setRGB(0, 0, w, h, pixels, 0, w);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ImgToByteArray(BufferedImage image) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            ImageOutputStream outputStream2 = ImageIO.createImageOutputStream(outputStream);
            ImageIO.write((RenderedImage)image, "BMP", outputStream2);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage byteArrayToImg(byte[] body) {
        ByteArrayInputStream bais = null;
        ImageInputStream inputStream = null;
        try {
            bais = new ByteArrayInputStream(body);
            inputStream = ImageIO.createImageInputStream(bais);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException e) {
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static BufferedImage StringToBufferedImage(String image) {
        try {
            byte[] bytes = new BASE64Decoder().decodeBuffer(image);
            return ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String BufferedImageToString(BufferedImage image) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "BMP", outputStream);
            return new BASE64Encoder().encode(outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getColorInHexFromRGB(int r, int g, int b) {
        return ImgTool.vali(ImgTool.getHexNum(b)) + ImgTool.vali(ImgTool.getHexNum(g)) + ImgTool.vali(ImgTool.getHexNum(r));
    }

    private static String vali(String s) {
        while (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    private static String getHexNum(int num) {
        int result = num / 16;
        int mod = num % 16;
        StringBuilder s = new StringBuilder();
        ImgTool.hexHelp(result, mod, s);
        return s.toString();
    }

    private static void hexHelp(int result, int mod, StringBuilder s) {
        char[] H = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (result > 0) {
            ImgTool.hexHelp(result / 16, result % 16, s);
        }
        s.append(H[mod]);
    }

    public static void saveToFile(BufferedImage object, String path) {
        try {
            FileOutputStream outputStream = null;
            outputStream = new FileOutputStream(path);
            ImageIO.write((RenderedImage)object, "png", outputStream);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] BufferedImageCompress(BufferedImage bufferedImage, float quality) {
        if (writer == null) {
            writer = ImageIO.getImageWritersByFormatName("JPEG").next();
            writeParam = (JPEGImageWriteParam)writer.getDefaultWriteParam();
            writeParam.setCompressionMode(2);
            writeParam.setProgressiveMode(0);
            ColorModel colorModel = ColorModel.getRGBdefault();
            writeParam.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(6, 6)));
        }
        writeParam.setCompressionQuality(quality);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageOutputStream ios = ImageIO.createImageOutputStream(outputStream);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(bufferedImage, null, null), writeParam);
            ios.close();
            outputStream.close();
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

