package com.mugui.spring.net.forward;

import java.util.LinkedList;

import org.springframework.stereotype.Component;

import com.mugui.spring.base.Task;
import com.mugui.spring.base.TaskInterface;
import com.mugui.spring.net.auto.AutoTask;
import com.mugui.spring.net.bean.NetBag;
import com.mugui.spring.util.HTTPUtil;
import com.mugui.util.Other;

@AutoTask
@Task(blank = 60000, time = 1000, value = Task.CYCLE)
@Component
public class ForwardTask implements TaskInterface {
	private LinkedList<ForwardBean> LinkedList = new LinkedList<>();

	public void init() {
		System.out.println(ForwardTask.class.getName() + "初始化"); 
	}

	@Override
	public void run() {
		synchronized (LinkedList) {
			if (LinkedList.isEmpty()) {
				return;
			}
			for (ForwardBean forwardBean : LinkedList) {
				NetBag netBag = new NetBag();
				netBag.setFunc("&forward.insert.New");
				netBag.setData(forwardBean);
				netBag.setHash(Other.MD5(netBag.toString()));
				System.out.println(HTTPUtil.post(forwardBean.get().getString("server_url"), netBag.toString()));
			}
		}
	}

	public void insert(ForwardBean forwardBean) {
		synchronized (LinkedList) {
			LinkedList.add(forwardBean);
		}
	}

}
