/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Arrangement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] datas;

    public Arrangement(String[] datas) {
        this.datas = datas;
    }

    public static long count(int n) {
        return Arrangement.count(n, n);
    }

    public static long count(int n, int m) {
        if (n == m) {
            return NumberUtil.factorial(n);
        }
        return n > m ? NumberUtil.factorial(n, n - m) : 0L;
    }

    public static long countAll(int n) {
        long total = 0L;
        for (int i2 = 1; i2 <= n; ++i2) {
            total += Arrangement.count(n, i2);
        }
        return total;
    }

    public List<String[]> select() {
        return this.select(this.datas.length);
    }

    public List<String[]> select(int m) {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Arrangement.count(this.datas.length, m));
        this.select(this.datas, new String[m], 0, result);
        return result;
    }

    public List<String[]> selectAll() {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Arrangement.countAll(this.datas.length));
        for (int i2 = 1; i2 <= this.datas.length; ++i2) {
            result.addAll(this.select(i2));
        }
        return result;
    }

    private void select(String[] datas, String[] resultList, int resultIndex, List<String[]> result) {
        if (resultIndex >= resultList.length) {
            if (!result.contains(resultList)) {
                result.add(Arrays.copyOf(resultList, resultList.length));
            }
            return;
        }
        for (int i2 = 0; i2 < datas.length; ++i2) {
            resultList[resultIndex] = datas[i2];
            this.select(ArrayUtil.remove(datas, i2), resultList, resultIndex + 1, result);
        }
    }
}

