/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.parser;

import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.parser.ValueParser;

public class SimpleValueParser
implements ValueParser {
    protected int min;
    protected int max;

    public SimpleValueParser(int min, int max) {
        if (min > max) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    @Override
    public int parse(String value) throws CronException {
        int i2;
        try {
            i2 = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new CronException(e, "Invalid integer value: '{}'", value);
        }
        if (i2 < this.min || i2 > this.max) {
            throw new CronException("Value {} out of range: [{} , {}]", i2, this.min, this.max);
        }
        return i2;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

