/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHealthChecker
implements Cloneable {
    protected String type = "unknown";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public abstract AbstractHealthChecker clone() throws CloneNotSupportedException;

    public void jsonAdapterCallback(SerializeWriter writer) {
    }

    private static boolean strEquals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static class Mysql
    extends AbstractHealthChecker {
        public static final String TYPE = "MYSQL";
        private String user;
        private String pwd;
        private String cmd;

        public Mysql() {
            this.type = TYPE;
        }

        public String getCmd() {
            return this.cmd;
        }

        public String getPwd() {
            return this.pwd;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public void setPwd(String pwd) {
            this.pwd = pwd;
        }

        @Override
        public void jsonAdapterCallback(SerializeWriter writer) {
            writer.writeFieldValue(',', "user", this.getUser());
            writer.writeFieldValue(',', "pwd", this.getPwd());
            writer.writeFieldValue(',', "cmd", this.getCmd());
        }

        public int hashCode() {
            return Objects.hash(this.user, this.pwd, this.cmd);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Mysql)) {
                return false;
            }
            Mysql other = (Mysql)obj;
            if (!AbstractHealthChecker.strEquals(this.user, other.getUser())) {
                return false;
            }
            if (!AbstractHealthChecker.strEquals(this.pwd, other.getPwd())) {
                return false;
            }
            return AbstractHealthChecker.strEquals(this.cmd, other.getCmd());
        }

        @Override
        public Mysql clone() throws CloneNotSupportedException {
            Mysql config = new Mysql();
            config.setUser(this.getUser());
            config.setPwd(this.getPwd());
            config.setCmd(this.getCmd());
            config.setType(this.getType());
            return config;
        }
    }

    public static class Tcp
    extends AbstractHealthChecker {
        public static final String TYPE = "TCP";

        public Tcp() {
            this.type = TYPE;
        }

        public int hashCode() {
            return Objects.hash(TYPE);
        }

        public boolean equals(Object obj) {
            return obj instanceof Tcp;
        }

        @Override
        public Tcp clone() throws CloneNotSupportedException {
            Tcp config = new Tcp();
            config.setType(this.type);
            return config;
        }
    }

    public static class Http
    extends AbstractHealthChecker {
        public static final String TYPE = "HTTP";
        private String path = "";
        private String headers = "";
        private int expectedResponseCode = 200;

        public Http() {
            this.type = TYPE;
        }

        public int getExpectedResponseCode() {
            return this.expectedResponseCode;
        }

        public void setExpectedResponseCode(int expectedResponseCode) {
            this.expectedResponseCode = expectedResponseCode;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getHeaders() {
            return this.headers;
        }

        public void setHeaders(String headers) {
            this.headers = headers;
        }

        @JSONField(serialize=false)
        public Map<String, String> getCustomHeaders() {
            if (StringUtils.isBlank(this.headers)) {
                return Collections.emptyMap();
            }
            HashMap<String, String> headerMap = new HashMap<String, String>(16);
            for (String s : this.headers.split("\\|")) {
                String[] splits = s.split(":");
                if (splits.length != 2) continue;
                headerMap.put(StringUtils.trim(splits[0]), StringUtils.trim(splits[1]));
            }
            return headerMap;
        }

        @Override
        public void jsonAdapterCallback(SerializeWriter writer) {
            writer.writeFieldValue(',', "path", this.getPath());
            writer.writeFieldValue(',', "headers", this.getHeaders());
        }

        public int hashCode() {
            return Objects.hash(this.path, this.headers, this.expectedResponseCode);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Http)) {
                return false;
            }
            Http other = (Http)obj;
            if (!AbstractHealthChecker.strEquals(this.type, other.getType())) {
                return false;
            }
            if (!AbstractHealthChecker.strEquals(this.path, other.getPath())) {
                return false;
            }
            if (!AbstractHealthChecker.strEquals(this.headers, other.getHeaders())) {
                return false;
            }
            return this.expectedResponseCode == other.getExpectedResponseCode();
        }

        @Override
        public Http clone() throws CloneNotSupportedException {
            Http config = new Http();
            config.setPath(this.getPath());
            config.setHeaders(this.getHeaders());
            config.setType(this.getType());
            config.setExpectedResponseCode(this.getExpectedResponseCode());
            return config;
        }
    }

    public static class None
    extends AbstractHealthChecker {
        public static final String TYPE = "NONE";

        public None() {
            this.setType(TYPE);
        }

        @Override
        public AbstractHealthChecker clone() throws CloneNotSupportedException {
            return new None();
        }
    }
}

